/*
 * Decompiled with CFR 0.152.
 */
package com.pagosoft.plaf;

import com.pagosoft.plaf.PgsComboBoxButtonUI;
import com.pagosoft.plaf.PgsLookAndFeel;
import com.pagosoft.plaf.PgsUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ComboBoxEditor;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.BasicComboPopup;
import javax.swing.plaf.basic.ComboPopup;
import javax.swing.plaf.metal.MetalComboBoxUI;
import javax.swing.text.JTextComponent;

public class PgsComboBoxUI
extends MetalComboBoxUI {
    private boolean iconPaintPressed = false;
    private PopupHandler popupHandler;
    private FocusHandler focusHandler;

    public static ComponentUI createUI(JComponent c) {
        return new PgsComboBoxUI();
    }

    public void paintCurrentValue(Graphics g, Rectangle bounds, boolean hasFocus) {
        Component c;
        ListCellRenderer<Object> renderer = this.comboBox.getRenderer();
        if (hasFocus && !this.isPopupVisible(this.comboBox)) {
            c = renderer.getListCellRendererComponent(this.listBox, this.comboBox.getSelectedItem(), -1, true, false);
        } else {
            c = renderer.getListCellRendererComponent(this.listBox, this.comboBox.getSelectedItem(), -1, false, false);
            c.setBackground(UIManager.getColor("ComboBox.background"));
        }
        c.setFont(this.comboBox.getFont());
        if (this.comboBox.isEnabled()) {
            c.setForeground(this.comboBox.getForeground());
            c.setBackground(this.comboBox.getBackground());
        } else {
            c.setForeground(UIManager.getColor("ComboBox.disabledForeground"));
            c.setBackground(UIManager.getColor("ComboBox.disabledBackground"));
        }
        boolean shouldValidate = false;
        if (c instanceof JPanel) {
            shouldValidate = true;
        }
        this.currentValuePane.paintComponent(g, c, this.comboBox, bounds.x, bounds.y, bounds.width, bounds.height, shouldValidate);
    }

    public void paintCurrentValueBackground(Graphics g, Rectangle bounds, boolean hasFocus) {
    }

    protected void installListeners() {
        super.installListeners();
        if (this.popup instanceof BasicComboPopup) {
            this.popupHandler = new PopupHandler();
            ((BasicComboPopup)this.popup).addPopupMenuListener(this.popupHandler);
            this.focusHandler = new FocusHandler();
            this.comboBox.addFocusListener(this.focusHandler);
        }
    }

    protected void uninstallListeners() {
        super.uninstallListeners();
        if (this.popup instanceof BasicComboPopup) {
            ((BasicComboPopup)this.popup).removePopupMenuListener(this.popupHandler);
            this.comboBox.removeFocusListener(this.focusHandler);
        }
    }

    public void paint(Graphics g, JComponent c) {
        this.hasFocus = this.comboBox.hasFocus();
        if (this.comboBox.isEditable()) {
            Color old = g.getColor();
            g.setColor(UIManager.getColor("TextField.background"));
            g.fillRect(0, 0, c.getWidth() + 1, c.getHeight() + 1);
            g.setColor(old);
        } else {
            Rectangle r = this.rectangleForCurrentValue();
            this.paintCurrentValueBackground(g, r, this.hasFocus);
            this.paintCurrentValue(g, r, this.hasFocus);
        }
    }

    protected ComboBoxEditor createEditor() {
        BasicComboBoxEditor.UIResource editor = new BasicComboBoxEditor.UIResource();
        Component ec = editor.getEditorComponent();
        if (ec instanceof JTextComponent) {
            ec.addFocusListener(new FocusListener(){

                public void focusGained(FocusEvent e) {
                    PgsComboBoxUI.this.comboBox.repaint();
                }

                public void focusLost(FocusEvent e) {
                    PgsComboBoxUI.this.comboBox.repaint();
                }
            });
        }
        return editor;
    }

    protected JButton createArrowButton() {
        PgsComboBoxButtonUI button = new PgsComboBoxButtonUI(this.comboBox, new PgsComboBoxIcon(), this.comboBox.isEditable(), this.currentValuePane, this.listBox);
        button.setMargin(new Insets(1, 1, 1, 1));
        button.setFocusPainted(this.comboBox.isEditable());
        return button;
    }

    protected ComboPopup createPopup() {
        BasicComboPopup basiccombopopup = new BasicComboPopup(this.comboBox){

            public void show(Component invoker, int x, int y) {
                super.show(invoker, x, y - 1);
            }
        };
        basiccombopopup.setBorder(UIManager.getBorder("ComboBox.popup.border"));
        basiccombopopup.applyComponentOrientation(this.comboBox.getComponentOrientation());
        return basiccombopopup;
    }

    protected ListCellRenderer createRenderer() {
        return new BasicComboBoxRenderer.UIResource(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component c = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                c.setComponentOrientation(PgsComboBoxUI.this.comboBox.getComponentOrientation());
                return c;
            }
        };
    }

    public void layoutComboBox(Container parent, MetalComboBoxUI.MetalComboBoxLayoutManager manager) {
        if (this.arrowButton != null) {
            if (this.arrowButton instanceof PgsComboBoxButtonUI) {
                Icon icon = ((PgsComboBoxButtonUI)this.arrowButton).getComboIcon();
                Insets buttonInsets = this.arrowButton.getInsets();
                Insets insets = this.comboBox.getInsets();
                int buttonWidth = icon.getIconWidth() + buttonInsets.left + buttonInsets.right;
                this.arrowButton.setBounds(PgsUtils.isLeftToRight(this.comboBox) ? this.comboBox.getWidth() - insets.right - buttonWidth : insets.left + 2, insets.top + 2, buttonWidth - 2, this.comboBox.getHeight() - insets.top - insets.bottom - 4);
            } else {
                Insets insets = this.comboBox.getInsets();
                int width = this.comboBox.getWidth();
                int height = this.comboBox.getHeight();
                this.arrowButton.setBounds(insets.left, insets.top, width - (insets.left + insets.right), height - (insets.top + insets.bottom));
            }
        }
        if (this.editor != null) {
            Rectangle cvb = this.rectangleForCurrentValue();
            this.editor.setBounds(cvb);
        }
    }

    protected Rectangle rectangleForCurrentValue() {
        int width = this.comboBox.getWidth();
        int height = this.comboBox.getHeight();
        Insets insets = this.getInsets();
        int buttonSize = height - (insets.top + insets.bottom);
        if (this.arrowButton != null) {
            if (this.arrowButton instanceof PgsComboBoxButtonUI) {
                Icon icon = ((PgsComboBoxButtonUI)this.arrowButton).getComboIcon();
                Insets buttonInsets = this.arrowButton.getInsets();
                buttonSize = icon.getIconWidth() + buttonInsets.left + buttonInsets.right;
            } else {
                buttonSize = this.arrowButton.getWidth();
            }
        }
        if (PgsUtils.isLeftToRight(this.comboBox)) {
            return new Rectangle(insets.left + 2, insets.top + 1, width - (insets.left + insets.right + buttonSize + 4), height - (insets.top + insets.bottom) - 2);
        }
        return new Rectangle(insets.left + buttonSize + 2, insets.top + 1, width - (insets.left + insets.right + buttonSize + 4), height - (insets.top + insets.bottom) - 2);
    }

    public Dimension getMinimumSize(JComponent c) {
        Dimension size;
        if (!this.isMinimumSizeDirty) {
            return new Dimension(this.cachedMinimumSize);
        }
        if (!this.comboBox.isEditable() && this.arrowButton != null && this.arrowButton instanceof PgsComboBoxButtonUI) {
            PgsComboBoxButtonUI button = (PgsComboBoxButtonUI)this.arrowButton;
            Insets buttonInsets = button.getInsets();
            Insets insets = this.comboBox.getInsets();
            size = this.getDisplaySize();
            size.width += insets.left + insets.right;
            size.width += buttonInsets.left + buttonInsets.right;
            size.width += buttonInsets.right + button.getComboIcon().getIconWidth();
            size.height += insets.top + insets.bottom;
            size.height += buttonInsets.top + buttonInsets.bottom;
            size.height -= 6;
        } else if (this.comboBox.isEditable() && this.arrowButton != null && this.editor != null) {
            size = super.getMinimumSize(c);
            Insets margin = this.arrowButton.getMargin();
            size.height += margin.top + margin.bottom - 2;
            size.width += margin.left + margin.right;
        } else {
            size = super.getMinimumSize(c);
        }
        this.cachedMinimumSize.setSize(size.width, size.height);
        this.isMinimumSizeDirty = false;
        return new Dimension(this.cachedMinimumSize);
    }

    public PropertyChangeListener createPropertyChangeListener() {
        return new PgsPropertyChangeListener();
    }

    private class FocusHandler
    implements FocusListener {
        private FocusHandler() {
        }

        public void focusGained(FocusEvent e) {
        }

        public void focusLost(FocusEvent e) {
            PgsComboBoxUI.this.iconPaintPressed = false;
            PgsComboBoxUI.this.comboBox.repaint();
        }
    }

    private class PopupHandler
    implements PopupMenuListener {
        private PopupHandler() {
        }

        public void popupMenuCanceled(PopupMenuEvent e) {
        }

        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            PgsComboBoxUI.this.iconPaintPressed = false;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    PgsComboBoxUI.this.comboBox.repaint();
                }
            });
        }

        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            PgsComboBoxUI.this.iconPaintPressed = true;
        }
    }

    private class PgsComboBoxIcon
    implements Icon {
        private PgsComboBoxIcon() {
        }

        public void paintIcon(Component component, Graphics g, int x, int y) {
            JButton c = (JButton)component;
            int iconWidth = this.getIconWidth();
            g.translate(x, y);
            g.setColor(c.isEnabled() ? PgsLookAndFeel.getControlInfo() : PgsLookAndFeel.getControlShadow());
            if (PgsComboBoxUI.this.iconPaintPressed) {
                g.drawLine(1, 3, 1 + iconWidth - 3, 3);
                g.drawLine(2, 2, 2 + iconWidth - 5, 2);
                g.drawLine(3, 1, 3 + iconWidth - 7, 1);
                g.drawLine(4, 0, 4 + iconWidth - 9, 0);
            } else {
                g.drawLine(1, 1, 1 + (iconWidth - 3), 1);
                g.drawLine(2, 2, 2 + (iconWidth - 5), 2);
                g.drawLine(3, 3, 3 + (iconWidth - 7), 3);
                g.drawLine(4, 4, 4 + (iconWidth - 9), 4);
            }
            g.translate(-x, -y);
        }

        public int getIconWidth() {
            return 10;
        }

        public int getIconHeight() {
            return 4;
        }
    }

    public class PgsPropertyChangeListener
    extends BasicComboBoxUI.PropertyChangeHandler {
        public PgsPropertyChangeListener() {
            super(PgsComboBoxUI.this);
        }

        public void propertyChange(PropertyChangeEvent e) {
            super.propertyChange(e);
            String propertyName = e.getPropertyName();
            if ("editable".equals(propertyName)) {
                PgsComboBoxButtonUI button = (PgsComboBoxButtonUI)PgsComboBoxUI.this.arrowButton;
                button.setIconOnly(PgsComboBoxUI.this.comboBox.isEditable());
                PgsComboBoxUI.this.comboBox.repaint();
                button.setFocusPainted(PgsComboBoxUI.this.comboBox.isEditable());
            } else if ("background".equals(propertyName)) {
                Color color = (Color)e.getNewValue();
                PgsComboBoxUI.this.arrowButton.setBackground(color);
                PgsComboBoxUI.this.listBox.setBackground(color);
            } else if ("foreground".equals(propertyName)) {
                Color color = (Color)e.getNewValue();
                PgsComboBoxUI.this.arrowButton.setForeground(color);
                PgsComboBoxUI.this.listBox.setForeground(color);
            }
        }
    }
}

