/*
 * Decompiled with CFR 0.152.
 */
package com.pagosoft.plaf;

import com.pagosoft.plaf.PgsBorders;
import com.pagosoft.plaf.PgsIconFactory;
import com.pagosoft.plaf.PgsTheme;
import com.pagosoft.plaf.PgsUtils;
import com.pagosoft.plaf.PlafOptions;
import com.pagosoft.plaf.ThemeFactory;
import com.pagosoft.swing.ColorUtils;
import java.awt.Color;
import java.awt.Frame;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalTheme;

public class PgsLookAndFeel
extends MetalLookAndFeel {
    private static MetalTheme currentTheme;
    private static Logger logger;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void loadUserSettings() {
        InputStream in = PgsLookAndFeel.class.getResourceAsStream("/pgs.properties");
        if (in != null) {
            try {
                logger.finest("Found a pgs.properties! Going to setup from pgs.properties!");
                Properties props = new Properties();
                props.load(in);
                PlafOptions.useShadowBorder(PgsLookAndFeel.getPropertyBoolValue(props, "pgs.shadowBorder", "false"));
                PlafOptions.useBoldFonts(PgsLookAndFeel.getPropertyBoolValue(props, "swing.boldMetal", "false"));
                PlafOptions.useBoldMenuFonts(PgsLookAndFeel.getPropertyBoolValue(props, "pgs.boldMenuFonts", "false"));
                PlafOptions.useExtraMargin(PgsLookAndFeel.getPropertyBoolValue(props, "pgs.extraMargin", "true"));
                PlafOptions.useDisabledIcon(PgsLookAndFeel.getPropertyBoolValue(props, "pgs.useDisabledIcon", "true"));
                PlafOptions.useToolBarIcon(PgsLookAndFeel.getPropertyBoolValue(props, "pgs.useToolBarIcon", "true"));
                PlafOptions.setAntialiasingEnabled(PgsLookAndFeel.getPropertyBoolValue(props, "pgs.aaEnabled", "false"));
                PlafOptions.setClearBorderEnabled(PgsLookAndFeel.getPropertyBoolValue(props, "pgs.clearBorderEnabled", "false"));
                PlafOptions.setFixHtmlDisplayEnabled(PgsLookAndFeel.getPropertyBoolValue(props, "pgs.fixHtmlDisplayEnabled", "true"));
                PlafOptions.setWheelTabbedPaneEnabled(PgsLookAndFeel.getPropertyBoolValue(props, "pgs.wheelTabEnabled", "true"));
                PlafOptions.setTabbedPaneRightClickSelectionEnabled(PgsLookAndFeel.getPropertyBoolValue(props, "pgs.tabbedPaneRightClickSelectionEnabled", "false"));
                PlafOptions.setTabReorderingEnabled(PgsLookAndFeel.getPropertyBoolValue(props, "pgs.tabReorderingEnabled", "false"));
                PlafOptions.setPaintRolloverButtonBorder(PgsLookAndFeel.getPropertyBoolValue(props, "pgs.paintRolloverButtonBorder", "true"));
                PlafOptions.setOfficeScrollBarEnabled(PgsLookAndFeel.getPropertyBoolValue(props, "pgs.officeScrollBarEnabled", "false"));
                PlafOptions.setVistaStyle(PgsLookAndFeel.getPropertyBoolValue(props, "pgs.vistaStyle", "false"));
                PlafOptions.setStyle("MenuBar", PgsLookAndFeel.getPropertyStyleValue(props, "pgs.style.menuBar", "flat"));
                PlafOptions.setStyle("MenuItem", PgsLookAndFeel.getPropertyStyleValue(props, "pgs.style.menuitem", "flat"));
                PlafOptions.setStyle("MenuBarMenu", PgsLookAndFeel.getPropertyStyleValue(props, "pgs.style.menuBarMenu", "flat"));
                PlafOptions.setStyle("ToolBar", PgsLookAndFeel.getPropertyStyleValue(props, "pgs.style.toolBar", "gradient"));
                PlafOptions.setStyle("ToolBarButton", PgsLookAndFeel.getPropertyStyleValue(props, "pgs.style.toolBarButton", "gradient"));
                PlafOptions.setStyle("Button", PgsLookAndFeel.getPropertyStyleValue(props, "pgs.style.button", "gradient"));
                PgsTheme theme = null;
                String themeProperty = props.getProperty("theme");
                theme = themeProperty != null ? ThemeFactory.getTheme(themeProperty) : ThemeFactory.createTheme(props);
                if (theme != null) {
                    PgsLookAndFeel.setCurrentTheme(theme);
                } else {
                    logger.warning("Could not create theme from pgs.properties");
                }
                logger.finest("pgs.properties have been loaded.");
            }
            catch (IOException ex) {
                logger.warning("Unexpected exception happened while loading properties: " + ex.toString());
            }
            finally {
                try {
                    in.close();
                }
                catch (IOException e) {
                    logger.warning("Unexpected exception happened while closing the stream: " + e.toString());
                }
            }
        }
    }

    private static boolean getPropertyBoolValue(Properties props, String key, String def) {
        return "true".equals(props.getProperty(key, def).trim().toLowerCase());
    }

    private static int getPropertyStyleValue(Properties props, String key, String def) {
        return "flat".equals(props.getProperty(key, def).trim().toLowerCase()) ? 0 : 1;
    }

    public PgsLookAndFeel() {
        UIManager.put("swing.boldMetal", PlafOptions.useBoldFonts() ? Boolean.TRUE : Boolean.FALSE);
    }

    public void initialize() {
        super.initialize();
        MetalLookAndFeel.setCurrentTheme(PgsLookAndFeel.getCurrentTheme());
    }

    public void uninitialize() {
        super.uninitialize();
    }

    public static void setAsLookAndFeel() {
        try {
            UIManager.setLookAndFeel("com.pagosoft.plaf.PgsLookAndFeel");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void updateAllUIs() {
        Frame[] frames = Frame.getFrames();
        for (int i = 0; i < frames.length; ++i) {
            if (!(frames[i] instanceof JFrame)) continue;
            SwingUtilities.updateComponentTreeUI(frames[i]);
        }
    }

    public static void setCurrentTheme(MetalTheme theme) {
        if (theme == null) {
            throw new IllegalArgumentException("theme must not be null!");
        }
        currentTheme = theme;
        MetalLookAndFeel.setCurrentTheme(theme);
    }

    public static MetalTheme getCurrentTheme() {
        if (currentTheme == null) {
            String theme = null;
            try {
                theme = System.getProperty("pgs.theme");
            }
            catch (Exception e) {
                logger.warning("Could not read system property 'pgs.theme'");
            }
            currentTheme = theme == null ? ThemeFactory.getDefaultTheme() : ThemeFactory.getTheme(theme);
        }
        return currentTheme;
    }

    public String getID() {
        return "com.pagosoft.plaf.PgsLookAndFeel";
    }

    public String getName() {
        return "PgsLookAndFeel";
    }

    public String getDescription() {
        return "Much like the original MetalLookAndFeel, but with gradients on menus, buttons, etc.";
    }

    public boolean isNativeLookAndFeel() {
        return false;
    }

    public boolean isSupportedLookAndFeel() {
        return true;
    }

    protected void initClassDefaults(UIDefaults table) {
        super.initClassDefaults(table);
        String prefix = "com.pagosoft.plaf.Pgs";
        Object[] def = new Object[]{"ButtonUI", prefix + "ButtonUI", "ToggleButtonUI", prefix + "ToggleButtonUI", "CheckBoxUI", prefix + "CheckBoxUI", "RadioButtonUI", prefix + "RadioButtonUI", "ComboBoxUI", prefix + "ComboBoxUI", "ToolBarUI", prefix + "ToolBarUI", "MenuUI", prefix + "MenuUI", "MenuBarUI", prefix + "MenuBarUI", "MenuItemUI", prefix + "MenuItemUI", "CheckBoxMenuItemUI", prefix + "CheckBoxMenuItemUI", "RadioButtonMenuItemUI", prefix + "RadioButtonMenuItemUI", "TabbedPaneUI", prefix + "TabbedPaneUI", "ProgressBarUI", prefix + "ProgressBarUI", "ScrollBarUI", prefix + "ScrollBarUI", "SplitPaneUI", prefix + "SplitPaneUI", "LabelUI", prefix + "LabelUI", "TextFieldUI", prefix + "TextFieldUI", "ToolTipUI", prefix + "ToolTipUI", "EditorPaneUI", prefix + "EditorPaneUI", "FormattedTextFieldUI", prefix + "FormattedTextFieldUI", "PasswordFieldUI", prefix + "PasswordFieldUI", "TextAreaUI", prefix + "TextAreaUI", "ScrollPaneUI", prefix + "ScrollPaneUI", "TableHeaderUI", prefix + "TableHeaderUI"};
        table.putDefaults(def);
    }

    protected void initComponentDefaults(UIDefaults table) {
        super.initComponentDefaults(table);
        MetalTheme theme = PgsLookAndFeel.getCurrentTheme();
        InsetsUIResource menuInsets = new InsetsUIResource(0, 2, 0, 3);
        InsetsUIResource buttonMargin = PlafOptions.useExtraMargin() ? new InsetsUIResource(1, 14, 1, 14) : new InsetsUIResource(1, 4, 1, 4);
        Color gradientStart = ColorUtils.getSimiliarColor(theme.getControl(), 1.4f);
        Color gradientEnd = ColorUtils.getSimiliarColor(theme.getControl(), 0.9f);
        Color specialGradientStart = ColorUtils.getSimiliarColor(theme.getPrimaryControlShadow(), 1.4f);
        Color specialGradientEnd = ColorUtils.getSimiliarColor(theme.getPrimaryControlShadow(), 0.9f);
        Object[] uiDefaults = new Object[]{"glow", ColorUtils.getTranslucentColor(theme.getPrimaryControl(), 175), "Button.border", PgsBorders.getButtonBorder(), "Button.margin", buttonMargin, "Button.rolloverBackground", theme.getControlShadow(), "Button.isFlat", PlafOptions.isFlat("Button"), "Button.gradientStart", gradientStart, "Button.gradientEnd", gradientEnd, "Button.rolloverGradientStart", gradientStart, "Button.rolloverGradientEnd", gradientEnd, "Button.selectedGradientStart", gradientEnd, "Button.selectedGradientEnd", gradientStart, "Button.rolloverVistaStyle", Boolean.FALSE, "ToggleButton.border", PgsBorders.getButtonBorder(), "ToggleButton.margin", buttonMargin, "ToggleButton.rolloverBackground", theme.getControlShadow(), "ToggleButton.isFlat", PlafOptions.isFlat("Button"), "ToggleButton.gradientStart", gradientStart, "ToggleButton.gradientEnd", gradientEnd, "ToggleButton.rolloverGradientStart", gradientStart, "ToggleButton.rolloverGradientEnd", gradientEnd, "ToggleButton.selectedGradientStart", ColorUtils.getSimiliarColor(theme.getControl(), 0.5f), "ToggleButton.selectedGradientEnd", ColorUtils.getSimiliarColor(theme.getControl(), 0.9f), "RadioButton.border", PgsBorders.getButtonBorder(), "RadioButton.icon", PgsIconFactory.getRadioButtonIcon(), "CheckBox.border", PgsBorders.getButtonBorder(), "CheckBox.icon", PgsIconFactory.getCheckBoxIcon(), "TabbedPane.tabGradientStart", gradientStart, "TabbedPane.tabGradientEnd", gradientEnd, "TabbedPane.focusPainted", Boolean.FALSE, "TabbedPane.buttonStyle.background", theme.getControl(), "TabbedPane.buttonStyle.selectedBackground", new ColorUIResource(ColorUtils.getTranslucentColor(theme.getPrimaryControlDarkShadow(), 100)), "TabbedPane.buttonStyle.rolloverBackground", new ColorUIResource(ColorUtils.getTranslucentColor(theme.getPrimaryControlShadow(), 100)), "TabbedPane.buttonStyle.selectedBorder", theme.getPrimaryControlDarkShadow(), "TabbedPane.buttonStyle.rolloverBorder", theme.getPrimaryControlDarkShadow(), "ToolBar.gradientStart", gradientStart, "ToolBar.gradientEnd", gradientEnd, "ToolBar.border", PgsBorders.getToolBarBorder(), "ToolBar.borderColor", theme.getControlShadow(), "ToolBarButton.margin", new InsetsUIResource(3, 3, 3, 3), "ToolBarButton.rolloverBackground", theme.getPrimaryControl(), "ToolBarButton.rolloverBorderColor", theme.getPrimaryControlDarkShadow(), "ToolBarButton.isFlat", PlafOptions.isFlat("ToolBarButton"), "ToolBarButton.gradientStart", gradientStart, "ToolBarButton.gradientEnd", gradientEnd, "ToolBarButton.rolloverGradientStart", specialGradientStart, "ToolBarButton.rolloverGradientEnd", specialGradientEnd, "ToolBarButton.selectedGradientStart", specialGradientEnd, "ToolBarButton.selectedGradientEnd", specialGradientStart, "ComboBox.border", PgsBorders.getTextFieldBorder(), "ComboBox.editorBorder", null, "ComboBox.selectionBackground", theme.getPrimaryControl(), "ComboBox.popup.border", BorderFactory.createLineBorder(theme.getControlDarkShadow()), "Menu.submenuPopupOffsetX", new Integer(0), "Menu.selectionBackground", theme.getPrimaryControl(), "Menu.selectedBorderMargin", menuInsets, "Menu.selectedBorderColor", theme.getPrimaryControlDarkShadow(), "Menu.gradientStart", specialGradientStart, "Menu.gradientEnd", specialGradientEnd, "Menu.borderPainted", Boolean.FALSE, "MenuItem.selectionBackground", theme.getPrimaryControl(), "MenuItem.selectedBorderMargin", menuInsets, "MenuItem.selectedBorderColor", theme.getPrimaryControlDarkShadow(), "MenuItem.gradientStart", specialGradientStart, "MenuItem.gradientEnd", specialGradientEnd, "MenuItem.isFlat", PlafOptions.isFlat("MenuItem"), "MenuItem.borderPainted", Boolean.FALSE, "CheckBoxMenuItem.selectionBackground", theme.getPrimaryControl(), "CheckBoxMenuItem.selectedBorderMargin", menuInsets, "CheckBoxMenuItem.selectedBorderColor", theme.getPrimaryControlDarkShadow(), "CheckBoxMenuItem.gradientStart", specialGradientStart, "CheckBoxMenuItem.gradientEnd", specialGradientEnd, "CheckBoxMenuItem.isFlat", PlafOptions.isFlat("MenuItem"), "CheckBoxMenuItem.borderPainted", Boolean.FALSE, "CheckBoxMenuItem.checkIcon", PgsIconFactory.getCheckBoxMenuItemIcon(), "RadioButtonMenuItem.selectionBackground", theme.getPrimaryControl(), "RadioButtonMenuItem.selectedBorderMargin", menuInsets, "RadioButtonMenuItem.selectedBorderColor", theme.getPrimaryControlDarkShadow(), "RadioButtonMenuItem.gradientStart", specialGradientStart, "RadioButtonMenuItem.gradientEnd", specialGradientEnd, "RadioButtonMenuItem.isFlat", PlafOptions.isFlat("MenuItem"), "RadioButtonMenuItem.borderPainted", Boolean.FALSE, "RadioButtonMenuItem.checkIcon", PgsIconFactory.getRadioButtonMenuItemIcon(), "MenuBar.isFlat", PlafOptions.isFlat("MenuBar"), "MenuBar.gradientStart", gradientStart, "MenuBar.gradientEnd", gradientEnd, "MenuBarMenu.isFlat", PlafOptions.isFlat("MenuBarMenu"), "MenuBarMenu.foreground", theme.getMenuForeground(), "MenuBarMenu.rolloverBorderColor", theme.getControlTextColor(), "MenuBarMenu.selectedBorderColor", theme.getPrimaryControlDarkShadow(), "MenuBarMenu.rolloverBackground", theme.getControlShadow(), "MenuBarMenu.selectedBackground", theme.getPrimaryControl(), "MenuBarMenu.rolloverBackgroundGradientStart", specialGradientStart, "MenuBarMenu.rolloverBackground.gradientStart", specialGradientStart, "MenuBarMenu.rolloverBackgroundGradientEnd", specialGradientEnd, "MenuBarMenu.rolloverBackground.gradientEnd", specialGradientEnd, "MenuBarMenu.selectedBackgroundGradientStart", specialGradientEnd, "MenuBarMenu.selectedBackgroundGradientEnd", specialGradientStart, "MenuBarMenu.selectedBackground.gradientStart", specialGradientEnd, "MenuBarMenu.selectedBackground.gradientEnd", specialGradientStart, "ProgressBar.border", PgsBorders.getComponentBorder(), "ProgressBar.gradientStart", gradientStart, "ProgressBar.gradientEnd", gradientEnd, "ProgressBar.innerGradientStart", specialGradientStart, "ProgressBar.innerGradientEnd", specialGradientEnd, "ProgressBar.innerDisabledGradientStart", gradientStart, "ProgressBar.innerDisabledGradientEnd", gradientEnd, "ProgressBar.innerBorderColor", theme.getPrimaryControlDarkShadow(), "ProgressBar.innerDisabledBorderColor", theme.getControlDarkShadow(), "ScrollBar.track", theme.getControlShadow(), "ScrollBar.trackHighlight", theme.getControl(), "ScrollPane.border", BorderFactory.createLineBorder(PgsLookAndFeel.getControlDarkShadow(), 1), "TextField.border", PgsBorders.getTextFieldBorder(), "TextField.margin", new InsetsUIResource(2, 2, 2, 2), "FormattedTextField.border", PgsBorders.getTextFieldBorder(), "FormattedTextField.margin", new InsetsUIResource(2, 2, 2, 2), "PasswordField.border", PgsBorders.getTextFieldBorder(), "PasswordField.margin", new InsetsUIResource(2, 2, 2, 2), "TextArea.margin", new InsetsUIResource(2, 2, 2, 2), "EditorPane.border", PgsBorders.getTextFieldBorder(), "EditorPane.margin", new InsetsUIResource(2, 2, 2, 2), "TextPane.border", PgsBorders.getTextFieldBorder(), "TextPane.margin", new InsetsUIResource(2, 2, 2, 2), "Tooltip.gradientStart", gradientStart, "Tooltip.gradientEnd", gradientEnd, "ToolTip.border", BorderFactory.createLineBorder(theme.getControlDarkShadow(), 1), "Table.scrollPaneBorder", PgsBorders.getComponentBorder(), "TabbedPane.background", PgsLookAndFeel.getControlShadow(), "SplitPane.border", null, "SplitPaneDivider.border", null, "OptionPane.errorIcon", PgsLookAndFeel.makeIcon(this.getClass(), "icons/Error.png"), "OptionPane.informationIcon", PgsLookAndFeel.makeIcon(this.getClass(), "icons/Inform.png"), "OptionPane.warningIcon", PgsLookAndFeel.makeIcon(this.getClass(), "icons/Warn.png"), "OptionPane.questionIcon", PgsLookAndFeel.makeIcon(this.getClass(), "icons/Question.png"), "FileView.computerIcon", PgsLookAndFeel.makeIcon(this.getClass(), "icons/Computer.png"), "FileView.directoryIcon", PgsLookAndFeel.makeIcon(this.getClass(), "icons/TreeClosed.png"), "FileView.fileIcon", PgsLookAndFeel.makeIcon(this.getClass(), "icons/File.png"), "FileView.floppyDriveIcon", PgsLookAndFeel.makeIcon(this.getClass(), "icons/FloppyDrive.png"), "FileView.hardDriveIcon", PgsLookAndFeel.makeIcon(this.getClass(), "icons/HardDrive.png"), "FileChooser.homeFolderIcon", PgsLookAndFeel.makeIcon(this.getClass(), "icons/HomeFolder.png"), "FileChooser.newFolderIcon", PgsLookAndFeel.makeIcon(this.getClass(), "icons/NewFolder.png"), "FileChooser.upFolderIcon", PgsLookAndFeel.makeIcon(this.getClass(), "icons/UpFolder.png"), "Tree.closedIcon", PgsLookAndFeel.makeIcon(this.getClass(), "icons/TreeClosed.png"), "Tree.openIcon", PgsLookAndFeel.makeIcon(this.getClass(), "icons/TreeOpen.png"), "Tree.leafIcon", PgsLookAndFeel.makeIcon(this.getClass(), "icons/TreeLeaf.png")};
        table.putDefaults(uiDefaults);
    }

    public Icon getDisabledSelectedIcon(JComponent component, Icon icon) {
        if (icon instanceof ImageIcon) {
            return PgsUtils.getDisabledButtonIcon(((ImageIcon)icon).getImage());
        }
        return null;
    }

    public static Color getGlow() {
        return UIManager.getColor("glow");
    }

    static {
        logger = Logger.getLogger("PgsLookAndFeel");
        PgsLookAndFeel.loadUserSettings();
    }
}

