/*
 * Decompiled with CFR 0.152.
 */
package com.pagosoft.plaf;

import com.pagosoft.plaf.PgsUtils;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import javax.swing.JComponent;
import javax.swing.JProgressBar;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicProgressBarUI;

public class PgsProgressBarUI
extends BasicProgressBarUI {
    private Rectangle boxRect;

    public static ComponentUI createUI(JComponent x) {
        return new PgsProgressBarUI();
    }

    public void paint(Graphics g, JComponent c) {
        JProgressBar prog = (JProgressBar)c;
        Graphics2D gfx = (Graphics2D)g;
        Dimension size = c.getSize();
        gfx.setColor(c.getBackground());
        gfx.fill(new Rectangle(0, 0, size.width, size.height));
        super.paint(g, c);
    }

    protected void paintDeterminate(Graphics g, JComponent c) {
        if (!(g instanceof Graphics2D)) {
            return;
        }
        Insets b = this.progressBar.getInsets();
        int barRectWidth = this.progressBar.getWidth() - (b.right + b.left);
        int barRectHeight = this.progressBar.getHeight() - (b.top + b.bottom);
        int amountFull = this.getAmountFull(b, barRectWidth, barRectHeight);
        Graphics2D g2 = (Graphics2D)g;
        g2.setColor(this.progressBar.getForeground());
        if (this.progressBar.getOrientation() == 0) {
            if (PgsUtils.isLeftToRight(c)) {
                if (this.progressBar.isEnabled()) {
                    g2.setPaint(new GradientPaint(0.0f, 0.0f, UIManager.getColor("ProgressBar.innerGradientStart"), 0.0f, barRectHeight / 2, UIManager.getColor("ProgressBar.innerGradientEnd"), true));
                } else {
                    g2.setPaint(new GradientPaint(0.0f, 0.0f, UIManager.getColor("ProgressBar.innerDisabledGradientStart"), 0.0f, barRectHeight / 2, UIManager.getColor("ProgressBar.innerDisabledGradientEnd"), true));
                }
                g2.fillRect(b.left + 2, b.top + 2, amountFull + b.left - b.right - 4, barRectHeight - 4);
                g2.setColor(UIManager.getColor(this.progressBar.isEnabled() ? "ProgressBar.innerBorderColor" : "ProgressBar.innerDisabledBorderColor"));
                g2.drawRect(b.left + 1, b.top + 1, amountFull + b.left - b.right - 3, barRectHeight - 3);
            } else {
                if (this.progressBar.isEnabled()) {
                    g2.setPaint(new GradientPaint(0.0f, 0.0f, UIManager.getColor("ProgressBar.innerGradientStart"), 0.0f, barRectHeight / 2, UIManager.getColor("ProgressBar.innerGradientEnd"), true));
                } else {
                    g2.setPaint(new GradientPaint(0.0f, 0.0f, UIManager.getColor("ProgressBar.innerDisabledGradientStart"), 0.0f, barRectHeight / 2, UIManager.getColor("ProgressBar.innerDisabledGradientEnd"), true));
                }
                g2.fillRect(b.left + barRectWidth - amountFull + 2, b.top + 2, amountFull + b.left - b.right - 4, barRectHeight - 4);
                g2.setColor(UIManager.getColor(this.progressBar.isEnabled() ? "ProgressBar.innerBorderColor" : "ProgressBar.innerDisabledBorderColor"));
                g2.drawRect(b.left + barRectWidth - amountFull - 1, b.top + 1, amountFull + b.left - b.right - 3, barRectHeight - 3);
            }
        } else {
            if (this.progressBar.isEnabled()) {
                g2.setPaint(new GradientPaint(0.0f, 0.0f, UIManager.getColor("ProgressBar.innerGradientStart"), barRectWidth / 2, 0.0f, UIManager.getColor("ProgressBar.innerGradientEnd"), true));
            } else {
                g2.setPaint(new GradientPaint(0.0f, 0.0f, UIManager.getColor("ProgressBar.innerDisabledGradientStart"), barRectWidth / 2, 0.0f, UIManager.getColor("ProgressBar.innerDisabledGradientEnd"), true));
            }
            g2.fillRect(b.left + 2, b.top + barRectHeight - b.bottom - amountFull - 3, barRectWidth - b.left - 3, amountFull + 2);
            g2.setColor(UIManager.getColor(this.progressBar.isEnabled() ? "ProgressBar.innerBorderColor" : "ProgressBar.innerDisabledBorderColor"));
            g2.drawRect(b.left + 1, b.top + barRectHeight - b.bottom - amountFull - 4, barRectWidth - b.left - 2, amountFull + 3);
        }
        if (this.progressBar.isStringPainted()) {
            this.paintString(g, b.left, b.top, barRectWidth, barRectHeight, amountFull, b);
        }
    }

    protected void paintIndeterminate(Graphics g, JComponent c) {
        if (!(g instanceof Graphics2D)) {
            return;
        }
        Insets b = this.progressBar.getInsets();
        int barRectWidth = this.progressBar.getWidth() - (b.right + b.left);
        int barRectHeight = this.progressBar.getHeight() - (b.top + b.bottom);
        Graphics2D g2 = (Graphics2D)g;
        this.boxRect = this.getBox(this.boxRect);
        if (this.boxRect != null) {
            if (this.progressBar.getOrientation() == 0) {
                g2.setPaint(new GradientPaint(0.0f, 0.0f, UIManager.getColor("ProgressBar.innerGradientStart"), 0.0f, barRectHeight / 2, UIManager.getColor("ProgressBar.innerGradientEnd"), true));
                g2.fillRect(this.boxRect.x + b.left + 2, this.boxRect.y + 2, this.boxRect.width + b.left - b.right - 4, this.boxRect.height - 4);
                g2.setColor(UIManager.getColor("ProgressBar.innerBorderColor"));
                g2.drawRect(this.boxRect.x + b.left + 1, this.boxRect.y + 1, this.boxRect.width + b.left - b.right - 3, this.boxRect.height - 3);
            } else {
                g2.setPaint(new GradientPaint(0.0f, 0.0f, UIManager.getColor("ProgressBar.innerGradientStart"), barRectWidth / 2, 0.0f, UIManager.getColor("ProgressBar.innerGradientEnd"), true));
                g2.fillRect(this.boxRect.x + b.left + 1, this.boxRect.y + b.top + 1, this.boxRect.width + b.left - b.right - 4, this.boxRect.height - 2 - b.bottom);
                g2.setColor(UIManager.getColor("ProgressBar.innerBorderColor"));
                g2.drawRect(this.boxRect.x + b.left, this.boxRect.y + b.top, this.boxRect.width + b.left - b.right - 3, this.boxRect.height - 1 - b.bottom);
            }
        }
        if (this.progressBar.isStringPainted()) {
            if (this.progressBar.getOrientation() == 0) {
                this.paintString(g2, b.left, b.top, barRectWidth, barRectHeight, this.boxRect.x, this.boxRect.width, b);
            } else {
                this.paintString(g2, b.left, b.top, barRectWidth, barRectHeight, this.boxRect.y, this.boxRect.height, b);
            }
        }
    }

    private void paintString(Graphics g, int x, int y, int width, int height, int fillStart, int amountFull, Insets b) {
        if (!(g instanceof Graphics2D)) {
            return;
        }
        PgsUtils.installAntialiasing(g);
        Graphics2D g2 = (Graphics2D)g;
        String progressString = this.progressBar.getString();
        g2.setFont(this.progressBar.getFont());
        Point renderLocation = this.getStringPlacement(g2, progressString, x, y, width, height);
        Rectangle oldClip = g2.getClipBounds();
        if (this.progressBar.getOrientation() == 0) {
            g2.setColor(this.getSelectionBackground());
            g2.drawString(progressString, renderLocation.x, renderLocation.y);
            g2.setColor(this.getSelectionForeground());
            g2.clipRect(fillStart, y, amountFull, height);
            g.drawString(progressString, renderLocation.x, renderLocation.y);
        } else {
            g2.setColor(this.getSelectionBackground());
            AffineTransform rotate = AffineTransform.getRotateInstance(1.5707963267948966);
            g2.setFont(this.progressBar.getFont().deriveFont(rotate));
            renderLocation = this.getStringPlacement(g2, progressString, x, y, width, height);
            g2.drawString(progressString, renderLocation.x, renderLocation.y);
            g2.setColor(this.getSelectionForeground());
            g2.clipRect(x, fillStart, width, amountFull);
            g2.drawString(progressString, renderLocation.x, renderLocation.y);
        }
        g2.setClip(oldClip);
        PgsUtils.uninstallAntialiasing(g);
    }
}

