/*
 * Decompiled with CFR 0.152.
 */
package com.pagosoft.plaf;

import com.pagosoft.plaf.PgsLookAndFeel;
import com.pagosoft.plaf.PgsUtils;
import com.pagosoft.plaf.PlafOptions;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.MouseInputAdapter;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicArrowButton;
import javax.swing.plaf.basic.BasicTabbedPaneUI;

public class PgsTabbedPaneUI
extends BasicTabbedPaneUI {
    private boolean paintFocus;
    private int rolloverTabIndex;
    private TabRolloverHandler tabHandler;
    private MyPropertyChangeHandler propHandler;
    private TabbedPaneMouseWheelScroller tabScrollHandler;
    private TabSelectionMouseHandler tabSelectionHandler;
    private static Logger logger = Logger.getLogger("PgsTabbedPaneUI");
    public static final String IS_SUB_TAB = "pgs.isSubTab";
    public static final String IS_BUTTON_STYLE = "pgs.isButtonStyle";
    public static final String NO_BORDER = "pgs.noBorder";
    private TabReorderHandler tabReorderingHandler;

    public static ComponentUI createUI(JComponent c) {
        return new PgsTabbedPaneUI();
    }

    protected void installDefaults() {
        super.installDefaults();
        this.updateBackgroundOpacity();
        this.paintFocus = UIManager.getBoolean("TabbedPane.focusPainted");
    }

    protected void installListeners() {
        super.installListeners();
        if (this.tabHandler == null) {
            this.tabHandler = new TabRolloverHandler();
        }
        this.tabPane.addMouseListener(this.tabHandler);
        this.tabPane.addMouseMotionListener(this.tabHandler);
        if (this.propHandler == null) {
            this.propHandler = new MyPropertyChangeHandler();
        }
        this.tabPane.addPropertyChangeListener(this.propHandler);
        if (PlafOptions.isWheelTabbedPaneEnabled()) {
            if (this.tabScrollHandler == null) {
                this.tabScrollHandler = new TabbedPaneMouseWheelScroller();
            }
            this.tabPane.addMouseWheelListener(this.tabScrollHandler);
        }
        if (PlafOptions.isTabbedPaneRightClickSelectionEnabled()) {
            if (this.tabSelectionHandler == null) {
                this.tabSelectionHandler = new TabSelectionMouseHandler();
            }
            this.tabPane.addMouseListener(this.tabSelectionHandler);
        }
        if (PlafOptions.isTabReorderingEnabled()) {
            this.enableReordering();
        }
    }

    protected void uninstallListeners() {
        super.uninstallListeners();
        this.tabPane.removeMouseListener(this.tabHandler);
        this.tabPane.removeMouseMotionListener(this.tabHandler);
        this.tabPane.removePropertyChangeListener(this.propHandler);
        if (this.tabScrollHandler != null) {
            this.tabPane.removeMouseWheelListener(this.tabScrollHandler);
        }
        if (this.tabSelectionHandler != null) {
            this.tabPane.removeMouseListener(this.tabSelectionHandler);
        }
        this.disableReordering();
    }

    private void updateBackgroundOpacity() {
        if (this.isSubTab() || this.isButtonStyle()) {
            this.tabPane.setOpaque(true);
            if (this.isSubTab()) {
                this.tabPane.setBackground(UIManager.getColor("TabbedPane.background"));
            } else if (this.isButtonStyle()) {
                this.tabPane.setBackground(UIManager.getColor("TabbedPane.buttonStyle.background"));
            }
        } else {
            this.tabPane.setOpaque(false);
        }
    }

    private boolean checkBooleanClientProperty(Object key) {
        Object o = this.tabPane.getClientProperty(key);
        if (o == null) {
            return false;
        }
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        if (o instanceof Integer) {
            return (Integer)o != 0;
        }
        logger.warning("It seems like you've used a wrong type for '" + key + "'. It should be a boolean, but is a " + o.getClass().getName());
        return true;
    }

    private boolean isSubTab() {
        return this.checkBooleanClientProperty(IS_SUB_TAB);
    }

    private boolean isButtonStyle() {
        return this.checkBooleanClientProperty(IS_BUTTON_STYLE);
    }

    private void mySetRolloverTab(int x, int y) {
        this.mySetRolloverTab(this.myTabForCoordinate(this.tabPane, x, y));
    }

    private int myTabForCoordinate(JTabbedPane pane, int x, int y) {
        Point p = new Point(x, y);
        for (int i = 0; i < this.tabPane.getTabCount(); ++i) {
            if (i >= this.rects.length || !this.rects[i].contains(p.x, p.y)) continue;
            return i;
        }
        return -1;
    }

    protected void mySetRolloverTab(int index) {
        if (index >= 0) {
            if (this.rolloverTabIndex != -1) {
                this.tabPane.repaint(this.rects[this.rolloverTabIndex]);
            }
            this.tabPane.repaint(this.rects[index]);
        } else if (this.rolloverTabIndex != -1 && this.rolloverTabIndex < this.rects.length) {
            this.tabPane.repaint(this.rects[this.rolloverTabIndex]);
        }
        this.rolloverTabIndex = index;
    }

    protected int getRolloverTab() {
        return this.rolloverTabIndex;
    }

    protected void paintTabBackground(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        if (this.isButtonStyle()) {
            if (isSelected) {
                g.setColor(UIManager.getColor("TabbedPane.buttonStyle.selectedBackground"));
                g.fillRect(x + 2, y + 2, w - 4, h - 4);
            }
            if (tabIndex == this.getRolloverTab() && this.tabPane.isEnabledAt(tabIndex)) {
                g.setColor(UIManager.getColor("TabbedPane.buttonStyle.rolloverBackground"));
                if (isSelected) {
                    g.fillRect(x + 2, y + 2, w - 4, h - 4);
                } else {
                    g.fillRect(x, y, w, h);
                }
            }
            return;
        }
        if (this.isSubTab() && !isSelected) {
            return;
        }
        Graphics2D gfx = (Graphics2D)g;
        if (isSelected) {
            gfx.setColor(UIManager.getColor("TabbedPane.selected"));
        } else {
            Color a = UIManager.getColor("TabbedPane.tabGradientStart");
            Color b = UIManager.getColor("TabbedPane.tabGradientEnd");
            gfx.setPaint(new GradientPaint(0.0f, y + 1, a, 0.0f, y + 1 + h, b));
        }
        switch (tabPlacement) {
            case 2: {
                gfx.fill(new Rectangle(x, y, w + 2, h));
                break;
            }
            case 4: {
                gfx.fill(new Rectangle(x - 2, y, w + 2, h));
                break;
            }
            case 3: {
                gfx.fill(new Rectangle(x, y - 2, w, h + 2));
                break;
            }
            default: {
                gfx.fill(new Rectangle(x, y, w - 2, h + 2));
            }
        }
        if (!isSelected && tabIndex == this.getRolloverTab() && this.tabPane.isEnabledAt(tabIndex)) {
            RenderingHints oldHints = gfx.getRenderingHints();
            gfx.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            gfx.setColor(PgsLookAndFeel.getGlow());
            Stroke oldStroke = gfx.getStroke();
            gfx.setStroke(PgsUtils.rolloverBorderStroke);
            switch (tabPlacement) {
                case 2: {
                    gfx.drawRoundRect(x + 1, y + 1, w + 1, h - 3, 5, 5);
                    break;
                }
                case 4: {
                    gfx.drawRoundRect(x - 2, y + 1, w + 1, h - 2, 5, 5);
                    break;
                }
                case 3: {
                    gfx.drawRoundRect(x + 1, y - 2, w - 3, h, 5, 5);
                    break;
                }
                default: {
                    gfx.drawRoundRect(x + 1, y + 1, w - 4, h + 1, 5, 5);
                }
            }
            gfx.setStroke(oldStroke);
            gfx.setRenderingHint(RenderingHints.KEY_ANTIALIASING, oldHints.get(RenderingHints.KEY_ANTIALIASING));
        }
    }

    protected void paintTabBorder(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        if (this.isButtonStyle()) {
            if (isSelected) {
                g.setColor(UIManager.getColor("TabbedPane.buttonStyle.selectedBorder"));
                g.drawRect(x + 2, y + 2, w - 4, h - 4);
            }
            if (tabIndex == this.getRolloverTab()) {
                g.setColor(UIManager.getColor("TabbedPane.buttonStyle.rolloverBorder"));
                if (isSelected) {
                    g.drawRect(x + 2, y + 2, w - 4, h - 4);
                } else {
                    g.drawRect(x, y, w, h);
                }
            }
            return;
        }
        if (this.isSubTab() && !isSelected) {
            g.setColor(PgsLookAndFeel.getControlDarkShadow());
            g.drawLine(x + w - 1, y, x + w - 1, y + h);
            return;
        }
        Graphics2D gfx = (Graphics2D)g;
        gfx.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        gfx.setColor(PgsLookAndFeel.getControlDarkShadow());
        if (this.isSubTab()) {
            switch (tabPlacement) {
                case 2: {
                    gfx.drawRect(x, y, w + 2, h);
                    break;
                }
                case 4: {
                    gfx.drawRect(x - 2, y, w + 2, h);
                    break;
                }
                case 3: {
                    gfx.drawRect(x, y - 2, w, h + 2);
                    break;
                }
                default: {
                    gfx.drawRect(x, y, w - 2, h + 2);
                    break;
                }
            }
        } else {
            switch (tabPlacement) {
                case 2: {
                    gfx.drawRoundRect(x, y, w + 2, h, 5, 5);
                    break;
                }
                case 4: {
                    gfx.drawRoundRect(x - 2, y, w + 2, h, 5, 5);
                    break;
                }
                case 3: {
                    gfx.drawRoundRect(x, y - 2, w, h + 2, 5, 5);
                    break;
                }
                default: {
                    gfx.drawRoundRect(x, y, w - 2, h + 2, 5, 5);
                }
            }
        }
        gfx.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
    }

    protected void paintFocusIndicator(Graphics g, int tabPlacement, Rectangle[] rects, int tabIndex, Rectangle iconRect, Rectangle textRect, boolean isSelected) {
        if (this.paintFocus) {
            super.paintFocusIndicator(g, tabPlacement, rects, tabIndex, iconRect, textRect, isSelected);
        }
    }

    protected void paintContentBorder(Graphics g, int tabPlacement, int selectedIndex) {
        int width = this.tabPane.getWidth();
        int height = this.tabPane.getHeight();
        Insets insets = this.tabPane.getInsets();
        Insets tabAreaInsets = this.getTabAreaInsets(tabPlacement);
        int x = insets.left;
        int y = insets.top;
        int w = width - insets.right - insets.left;
        int h = height - insets.top - insets.bottom;
        boolean tabsOverlapBorder = true;
        int tabAreaWidth = 0;
        int tabAreaHeight = 0;
        switch (tabPlacement) {
            case 2: {
                tabAreaWidth = this.calculateTabAreaWidth(tabPlacement, this.runCount, this.maxTabWidth);
                x += tabAreaWidth;
                if (tabsOverlapBorder) {
                    x -= tabAreaInsets.right;
                }
                w -= x - insets.left;
                break;
            }
            case 4: {
                tabAreaWidth = this.calculateTabAreaWidth(tabPlacement, this.runCount, this.maxTabWidth);
                w -= tabAreaWidth;
                if (!tabsOverlapBorder) break;
                w += tabAreaInsets.left;
                break;
            }
            case 3: {
                tabAreaHeight = this.calculateTabAreaHeight(tabPlacement, this.runCount, this.maxTabHeight);
                h -= tabAreaHeight;
                if (!tabsOverlapBorder) break;
                h += tabAreaInsets.top;
                break;
            }
            default: {
                tabAreaHeight = this.calculateTabAreaHeight(tabPlacement, this.runCount, this.maxTabHeight);
                y += tabAreaHeight;
                if (tabsOverlapBorder) {
                    y -= tabAreaInsets.bottom;
                }
                h -= y - insets.top;
            }
        }
        Color color = UIManager.getColor("TabbedPane.contentAreaColor");
        Color selectedColor = UIManager.getColor("TabbedPane.selected");
        if (color != null) {
            g.setColor(color);
        } else if (selectedColor == null) {
            g.setColor(this.tabPane.getBackground());
        } else {
            g.setColor(selectedColor);
        }
        g.fillRect(x, y, w, h);
        if (this.checkBooleanClientProperty(NO_BORDER)) {
            return;
        }
        g.setColor(PgsLookAndFeel.getControlDarkShadow());
        PgsUtils.drawRoundRect(g, x, y, w - 1, h - 1);
        if (selectedIndex > -1 && !this.isButtonStyle()) {
            Rectangle selRect = this.getTabBounds(selectedIndex, this.calcRect);
            g.setColor(UIManager.getColor("TabbedPane.selected"));
            switch (tabPlacement) {
                case 1: {
                    g.fillRect(selRect.x + 1, selRect.y + selRect.height - 2, selRect.width - 2, 1);
                    if (selectedIndex != 0) break;
                    g.setColor(PgsLookAndFeel.getControlDarkShadow());
                    g.drawLine(x, selRect.y + selRect.height - 2, x, selRect.y + selRect.height + 2);
                    break;
                }
                case 3: {
                    g.fillRect(selRect.x + 1, selRect.y + 1, selRect.width - 1, 1);
                    if (selectedIndex != 0) break;
                    g.setColor(PgsLookAndFeel.getControlDarkShadow());
                    g.drawLine(x, selRect.y - 2, x, selRect.y + 2);
                    break;
                }
                case 2: {
                    g.fillRect(selRect.x + selRect.width - 2, selRect.y + 1, 1, selRect.height - 1);
                    if (selectedIndex != 0) break;
                    g.setColor(PgsLookAndFeel.getControlDarkShadow());
                    g.drawLine(selRect.x + selRect.width - 2, selRect.y, selRect.x + selRect.width + 2, selRect.y);
                    break;
                }
                case 4: {
                    g.fillRect(selRect.x + 1, selRect.y + 1, 1, selRect.height - 1);
                    if (selectedIndex != 0) break;
                    g.setColor(PgsLookAndFeel.getControlDarkShadow());
                    g.drawLine(selRect.x - 2, selRect.y, selRect.x + 2, selRect.y);
                }
            }
        }
    }

    protected void paintText(Graphics g, int tabPlacement, Font font, FontMetrics metrics, int tabIndex, String title, Rectangle textRect, boolean isSelected) {
        PgsUtils.installAntialiasing(g);
        super.paintText(g, tabPlacement, font, metrics, tabIndex, title, textRect, isSelected);
        PgsUtils.uninstallAntialiasing(g);
    }

    protected JButton createScrollButton(int direction) {
        if (direction != 5 && direction != 1 && direction != 3 && direction != 7) {
            throw new IllegalArgumentException("Direction must be one of: SOUTH, NORTH, EAST or WEST");
        }
        return new ScrollableTabButton(direction);
    }

    public void enableReordering() {
        if (this.tabReorderingHandler == null) {
            this.tabReorderingHandler = new TabReorderHandler();
        }
        this.tabPane.addMouseListener(this.tabReorderingHandler);
        this.tabPane.addMouseMotionListener(this.tabReorderingHandler);
    }

    public void disableReordering() {
        this.tabPane.removeMouseListener(this.tabReorderingHandler);
        this.tabPane.removeMouseMotionListener(this.tabReorderingHandler);
    }

    public class TabbedPaneMouseWheelScroller
    implements MouseWheelListener {
        public void mouseWheelMoved(MouseWheelEvent e) {
            JTabbedPane tabPane = (JTabbedPane)e.getSource();
            int dir = e.getWheelRotation();
            int selIndex = tabPane.getSelectedIndex();
            int maxIndex = tabPane.getTabCount() - 1;
            selIndex = selIndex == 0 && dir < 0 || selIndex == maxIndex && dir > 0 ? maxIndex - selIndex : (selIndex += dir);
            tabPane.setSelectedIndex(selIndex);
        }
    }

    public class SelectTabAction
    extends AbstractAction {
        private JTabbedPane tabPane;
        private int index;

        public SelectTabAction(JTabbedPane tabPane, int index) {
            super(tabPane.getTitleAt(index), tabPane.getIconAt(index));
            this.tabPane = tabPane;
            this.index = index;
        }

        public void actionPerformed(ActionEvent e) {
            this.tabPane.setSelectedIndex(this.index);
        }
    }

    public class TabSelectionMouseHandler
    extends MouseAdapter {
        public void mouseClicked(MouseEvent e) {
            if (SwingUtilities.isRightMouseButton(e)) {
                JTabbedPane tabPane = (JTabbedPane)e.getSource();
                JPopupMenu menu = new JPopupMenu();
                int tabCount = tabPane.getTabCount();
                for (int i = 0; i < tabCount; ++i) {
                    menu.add(new SelectTabAction(tabPane, i));
                }
                menu.show(tabPane, e.getX(), e.getY());
            }
        }
    }

    public class TabReorderHandler
    extends MouseInputAdapter {
        private int draggedTabIndex = -1;

        protected TabReorderHandler() {
        }

        public void mouseReleased(MouseEvent e) {
            this.draggedTabIndex = -1;
        }

        public void mouseDragged(MouseEvent e) {
            if (this.draggedTabIndex == -1) {
                return;
            }
            int targetTabIndex = PgsTabbedPaneUI.this.tabPane.getUI().tabForCoordinate(PgsTabbedPaneUI.this.tabPane, e.getX(), e.getY());
            if (targetTabIndex != -1 && targetTabIndex != this.draggedTabIndex) {
                boolean isForwardDrag = targetTabIndex > this.draggedTabIndex;
                PgsTabbedPaneUI.this.tabPane.insertTab(PgsTabbedPaneUI.this.tabPane.getTitleAt(this.draggedTabIndex), PgsTabbedPaneUI.this.tabPane.getIconAt(this.draggedTabIndex), PgsTabbedPaneUI.this.tabPane.getComponentAt(this.draggedTabIndex), PgsTabbedPaneUI.this.tabPane.getToolTipTextAt(this.draggedTabIndex), isForwardDrag ? targetTabIndex + 1 : targetTabIndex);
                this.draggedTabIndex = targetTabIndex;
                PgsTabbedPaneUI.this.tabPane.setSelectedIndex(this.draggedTabIndex);
            }
        }

        public void mousePressed(MouseEvent e) {
            this.draggedTabIndex = PgsTabbedPaneUI.this.tabPane.getUI().tabForCoordinate(PgsTabbedPaneUI.this.tabPane, e.getX(), e.getY());
        }
    }

    private class ScrollableTabButton
    extends BasicArrowButton
    implements UIResource,
    SwingConstants {
        public ScrollableTabButton(int direction) {
            super(direction, UIManager.getColor("TabbedPane.selected"), UIManager.getColor("TabbedPane.shadow"), UIManager.getColor("TabbedPane.darkShadow"), UIManager.getColor("TabbedPane.highlight"));
            this.setOpaque(false);
        }

        public void paint(Graphics g) {
            int w = this.getSize().width;
            int h = this.getSize().height;
            Color origColor = g.getColor();
            boolean isPressed = this.getModel().isPressed();
            boolean isEnabled = this.isEnabled();
            if (isEnabled && this.getModel().isRollover()) {
                g.setColor(isPressed ? PgsLookAndFeel.getPrimaryControlShadow() : UIManager.getColor("ToolBarButton.rolloverBackground"));
                g.fillRect(0, 0, w - 2, h - 2);
                g.setColor(UIManager.getColor("ToolBarButton.rolloverBorderColor"));
                g.drawRect(0, 0, w - 2, h - 2);
            }
            if (h < 5 || w < 5) {
                g.setColor(origColor);
                return;
            }
            if (isPressed) {
                g.translate(1, 1);
            }
            int size = Math.min((h - 4) / 3, (w - 4) / 3);
            size = Math.max(size, 2);
            this.paintTriangle(g, (w - size) / 2, (h - size) / 2, size, this.direction, isEnabled);
            if (isPressed) {
                g.translate(-1, -1);
            }
            g.setColor(origColor);
        }
    }

    public class MyPropertyChangeHandler
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent e) {
            if (PgsTabbedPaneUI.IS_SUB_TAB.equals(e.getPropertyName()) || PgsTabbedPaneUI.IS_BUTTON_STYLE.equals(e.getPropertyName())) {
                PgsTabbedPaneUI.this.updateBackgroundOpacity();
            } else if ("wheelScrolling".equals(e.getPropertyName())) {
                if (PgsTabbedPaneUI.this.checkBooleanClientProperty("wheelScrolling")) {
                    if (PgsTabbedPaneUI.this.tabScrollHandler == null) {
                        PgsTabbedPaneUI.this.tabScrollHandler = new TabbedPaneMouseWheelScroller();
                    }
                    PgsTabbedPaneUI.this.tabPane.addMouseWheelListener(PgsTabbedPaneUI.this.tabScrollHandler);
                } else if (PgsTabbedPaneUI.this.tabScrollHandler != null) {
                    PgsTabbedPaneUI.this.tabPane.removeMouseWheelListener(PgsTabbedPaneUI.this.tabScrollHandler);
                }
            } else if ("rightClickSelection".equals(e.getPropertyName())) {
                if (PgsTabbedPaneUI.this.checkBooleanClientProperty("rightClickSelection")) {
                    if (PgsTabbedPaneUI.this.tabSelectionHandler == null) {
                        PgsTabbedPaneUI.this.tabSelectionHandler = new TabSelectionMouseHandler();
                    }
                    PgsTabbedPaneUI.this.tabPane.addMouseListener(PgsTabbedPaneUI.this.tabSelectionHandler);
                } else if (PgsTabbedPaneUI.this.tabSelectionHandler != null) {
                    PgsTabbedPaneUI.this.tabPane.removeMouseListener(PgsTabbedPaneUI.this.tabSelectionHandler);
                }
            } else if ("tabReordering".equals(e.getPropertyName())) {
                if (PgsTabbedPaneUI.this.checkBooleanClientProperty("tabReordering")) {
                    PgsTabbedPaneUI.this.enableReordering();
                } else {
                    PgsTabbedPaneUI.this.disableReordering();
                }
            }
        }
    }

    protected class TabRolloverHandler
    implements MouseListener,
    MouseMotionListener {
        protected TabRolloverHandler() {
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
            PgsTabbedPaneUI.this.mySetRolloverTab(e.getX(), e.getY());
        }

        public void mouseExited(MouseEvent e) {
            PgsTabbedPaneUI.this.mySetRolloverTab(-1);
        }

        public void mousePressed(MouseEvent e) {
        }

        public void mouseDragged(MouseEvent e) {
        }

        public void mouseMoved(MouseEvent e) {
            PgsTabbedPaneUI.this.mySetRolloverTab(e.getX(), e.getY());
        }
    }
}

