/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.standalone;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.flow.standalone.AbstractStandalone;
import adams.flow.standalone.webserver.DefaultHandler;
import adams.flow.standalone.webserver.Handler;
import adams.flow.standalone.webserver.ResourceHandler;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.server.nio.SelectChannelConnector;

public class WebServer
extends AbstractStandalone {
    private static final long serialVersionUID = 3822479609541053446L;
    protected int m_Port;
    protected Handler[] m_Handlers;
    protected Server m_Server;

    public String globalInfo() {
        return "Provides a simple web server using an embedded jetty server.\nDepending on the used handlers, it can do more than just serve static files.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("port", "port", (Object)8080, (Number)1, (Number)65536);
        this.m_OptionManager.add("handler", "handlers", (Object)this.getDefaultHandlers());
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"port", (Object)this.m_Port, (String)"port: ");
    }

    public void setPort(int value) {
        if (value >= 1 && value <= 65536) {
            this.m_Port = value;
            this.reset();
        } else {
            this.getLogger().severe("Port has to satisfy 1<=x<=65536, provided: " + value);
        }
    }

    public int getPort() {
        return this.m_Port;
    }

    public String portTipText() {
        return "The port to use.";
    }

    protected Handler[] getDefaultHandlers() {
        return new Handler[]{new ResourceHandler(), new DefaultHandler()};
    }

    public void setHandlers(Handler[] value) {
        this.m_Handlers = value;
        this.reset();
    }

    public Handler[] getHandlers() {
        return this.m_Handlers;
    }

    public String handlersTipText() {
        return "The handlers to use.";
    }

    protected String doExecute() {
        String result = null;
        this.m_Server = new Server();
        SelectChannelConnector connector = new SelectChannelConnector();
        connector.setPort(this.m_Port);
        this.m_Server.addConnector((Connector)connector);
        org.eclipse.jetty.server.Handler[] list = new org.eclipse.jetty.server.Handler[this.m_Handlers.length];
        for (int i = 0; i < this.m_Handlers.length; ++i) {
            list[i] = this.m_Handlers[i].configureHandler();
        }
        HandlerList handlers = new HandlerList();
        handlers.setHandlers(list);
        this.m_Server.setHandler((org.eclipse.jetty.server.Handler)handlers);
        try {
            this.m_Server.start();
        }
        catch (Exception e) {
            result = this.handleException("Failed to start jetty server", e);
            this.m_Server = null;
        }
        return result;
    }

    public void stopExecution() {
        if (this.m_Server != null) {
            try {
                this.m_Server.stop();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.m_Server = null;
        }
        super.stopExecution();
    }
}

