/*
 * Decompiled with CFR 0.152.
 */
package adams.data.io.input;

import adams.core.io.FileUtils;
import adams.data.heatmap.Heatmap;
import adams.data.io.input.AbstractHeatmapReader;
import adams.data.report.Report;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.logging.Level;

public class FloatMatrixHeatmapReader
extends AbstractHeatmapReader {
    private static final long serialVersionUID = -2903357410192470809L;
    protected int m_Height;
    protected int m_Width;

    public String globalInfo() {
        return "Reads heat map files (2-D array of single precision floating point numbers).";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("height", "height", (Object)this.getDefaultHeight(), (Number)1, null);
        this.m_OptionManager.add("width", "width", (Object)this.getDefaultWidth(), (Number)1, null);
    }

    protected int getDefaultHeight() {
        return 240;
    }

    public void setHeight(int value) {
        this.m_Height = value;
        this.reset();
    }

    public int getHeight() {
        return this.m_Height;
    }

    public String heightTipText() {
        return "The height of the heatmap.";
    }

    protected int getDefaultWidth() {
        return 320;
    }

    public void setWidth(int value) {
        this.m_Width = value;
        this.reset();
    }

    public int getWidth() {
        return this.m_Width;
    }

    public String widthTipText() {
        return "The width of the heatmap.";
    }

    public String getFormatDescription() {
        return "Float matrix Heatmap";
    }

    public String[] getFormatExtensions() {
        return new String[]{"dat"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readData() {
        Heatmap map;
        DataInputStream stream = null;
        FileInputStream fis = null;
        try {
            int read;
            Report report = Heatmap.createEmptyReport();
            map = new Heatmap(this.m_Height, this.m_Width);
            map.setReport(report);
            fis = new FileInputStream(this.m_Input.getAbsoluteFile());
            stream = new DataInputStream(fis);
            int x = 0;
            int y = 0;
            byte[] bytes = new byte[4];
            do {
                if ((read = stream.read(bytes)) != 4) continue;
                int ivalue = ByteBuffer.wrap(new byte[]{bytes[3], bytes[2], bytes[1], bytes[0]}).getInt();
                float fvalue = Float.intBitsToFloat(ivalue);
                map.set(y, x, fvalue);
                if (++x != this.m_Width) continue;
                x = 0;
                if (++y == this.m_Height) break;
            } while (read == 4);
        }
        catch (Exception e) {
            try {
                this.getLogger().log(Level.SEVERE, "Failed to read heatmap from '" + this.m_Input + "'!", e);
                map = null;
            }
            catch (Throwable throwable) {
                FileUtils.closeQuietly(stream);
                FileUtils.closeQuietly(fis);
                throw throwable;
            }
            FileUtils.closeQuietly(stream);
            FileUtils.closeQuietly((InputStream)fis);
        }
        FileUtils.closeQuietly((InputStream)stream);
        FileUtils.closeQuietly((InputStream)fis);
        if (map != null) {
            this.m_ReadData.add(map);
        }
    }
}

