/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.heatmap.plugins;

import adams.core.option.OptionUtils;
import adams.data.image.AbstractImageContainer;
import adams.data.image.BufferedImageContainer;
import adams.data.image.transformer.AbstractBufferedImageTransformer;
import adams.data.image.transformer.PassThrough;
import adams.gui.visualization.heatmap.plugins.AbstractApplyImageTransformer;
import java.awt.image.BufferedImage;

public class BufferedImageTransformer
extends AbstractApplyImageTransformer {
    private static final long serialVersionUID = 8515360604357492725L;

    public String getMenu() {
        return "Process";
    }

    public String getCaption() {
        return "BufferedImage transformer...";
    }

    public String getIconName() {
        return "duke.png";
    }

    @Override
    protected Class getEditorType() {
        return AbstractBufferedImageTransformer.class;
    }

    @Override
    protected Object getDefaultValue() {
        return new PassThrough();
    }

    protected String createLogEntry() {
        return ((Object)((Object)this)).getClass().getSimpleName() + ": " + OptionUtils.getCommandLine((Object)this.m_Editor.getValue());
    }

    @Override
    protected BufferedImage process(BufferedImage image) {
        BufferedImage result = null;
        this.setLastSetup(this.m_Editor.getValue());
        AbstractBufferedImageTransformer transformer = (AbstractBufferedImageTransformer)this.m_Editor.getValue();
        BufferedImageContainer input = new BufferedImageContainer();
        input.setImage((Object)image);
        BufferedImageContainer[] transformed = (BufferedImageContainer[])transformer.transform((AbstractImageContainer)input);
        if (transformed.length == 0) {
            this.getLogger().severe("No filtered image generated!");
        }
        if (transformed.length > 1) {
            this.getLogger().warning("Generated more than one image, using only first one.");
        }
        if (transformed.length >= 1) {
            result = (BufferedImage)transformed[0].getImage();
        }
        return result;
    }
}

