/*
 * Decompiled with CFR 0.152.
 */
package org.postgis.java2d;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.logging.Logger;
import org.postgis.PGbox2d;
import org.postgis.PGbox3d;
import org.postgis.java2d.PGShapeGeometry;
import org.postgresql.Driver;
import org.postgresql.PGConnection;

public class Java2DWrapper
extends Driver {
    private static final String POSTGRES_PROTOCOL = "jdbc:postgresql:";
    public static final String POSTGIS_PROTOCOL = "jdbc:postgis_j2d:";
    public static final String REVISION = "$Revision: 1980 $";

    public Connection connect(String string, Properties properties) throws SQLException {
        string = Java2DWrapper.mangleURL(string);
        Connection connection = super.connect(string, properties);
        Java2DWrapper.addGISTypes((PGConnection)connection);
        return connection;
    }

    public static void addGISTypes(PGConnection pGConnection) throws SQLException {
        pGConnection.addDataType("geometry", PGShapeGeometry.class);
        pGConnection.addDataType("box3d", PGbox3d.class);
        pGConnection.addDataType("box2d", PGbox2d.class);
    }

    public static String mangleURL(String string) throws SQLException {
        if (string.startsWith(POSTGIS_PROTOCOL)) {
            return POSTGRES_PROTOCOL + string.substring(POSTGIS_PROTOCOL.length());
        }
        throw new SQLException("Unknown protocol or subprotocol in url " + string);
    }

    public boolean acceptsURL(String string) throws SQLException {
        try {
            string = Java2DWrapper.mangleURL(string);
        }
        catch (SQLException sQLException) {
            return false;
        }
        return super.acceptsURL(string);
    }

    public int getMajorVersion() {
        return super.getMajorVersion();
    }

    public int getMinorVersion() {
        return super.getMinorVersion();
    }

    public static String getVersion() {
        return "Java2DWrapper $Revision: 1980 $, wrapping " + Driver.getVersion();
    }

    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new UnsupportedOperationException("getParentLogger");
    }

    static {
        try {
            DriverManager.registerDriver((java.sql.Driver)((Object)new Java2DWrapper()));
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
    }
}

