/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.nn.alg;

import org.ddogleg.nn.alg.KdTree;
import org.ddogleg.nn.alg.KdTreeSearch1;

public class KdTreeSearch1Standard
implements KdTreeSearch1 {
    private KdTree tree;
    private double[] target;
    private double maxDistanceSq = Double.MAX_VALUE;
    private double bestDistanceSq;
    private KdTree.Node closest;

    @Override
    public void setTree(KdTree tree) {
        this.tree = tree;
    }

    @Override
    public void setMaxDistance(double maxDistance) {
        this.maxDistanceSq = maxDistance;
    }

    @Override
    public KdTree.Node findNeighbor(double[] target) {
        if (this.tree.root == null) {
            return null;
        }
        this.target = target;
        this.closest = null;
        this.bestDistanceSq = this.maxDistanceSq;
        this.stepClosest(this.tree.root);
        return this.closest;
    }

    @Override
    public double getDistance() {
        return this.bestDistanceSq;
    }

    private void stepClosest(KdTree.Node node) {
        KdTree.Node further;
        KdTree.Node nearer;
        double splitValue;
        if (node == null) {
            return;
        }
        if (node.isLeaf()) {
            double distSq;
            if (node.point != null && (distSq = KdTree.distanceSq(node, this.target, this.tree.N)) <= this.bestDistanceSq && (this.closest == null || distSq < this.bestDistanceSq)) {
                this.closest = node;
                this.bestDistanceSq = distSq;
            }
            return;
        }
        double distSq = KdTree.distanceSq(node, this.target, this.tree.N);
        if (distSq <= this.bestDistanceSq && (this.closest == null || distSq < this.bestDistanceSq)) {
            this.closest = node;
            this.bestDistanceSq = distSq;
        }
        if (this.target[node.split] <= (splitValue = node.point[node.split])) {
            nearer = node.left;
            further = node.right;
        } else {
            nearer = node.right;
            further = node.left;
        }
        this.stepClosest(nearer);
        double dx = splitValue - this.target[node.split];
        double dx2 = dx * dx;
        if (dx2 <= this.bestDistanceSq && (this.closest == null || dx2 < this.bestDistanceSq)) {
            this.stepClosest(further);
        }
    }
}

