/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.optimization.wrap;

import org.ddogleg.optimization.functions.CoupledJacobian;
import org.ddogleg.optimization.functions.FunctionNtoM;
import org.ddogleg.optimization.functions.FunctionNtoMxN;

public class Individual_to_CoupledJacobian
implements CoupledJacobian {
    FunctionNtoM func;
    FunctionNtoMxN jacobian;
    double[] x;

    public Individual_to_CoupledJacobian(FunctionNtoM func, FunctionNtoMxN jacobian) {
        if (func.getNumOfOutputsM() != jacobian.getNumOfOutputsM()) {
            throw new IllegalArgumentException("M not equal");
        }
        if (func.getNumOfInputsN() != jacobian.getNumOfInputsN()) {
            throw new IllegalArgumentException("N not equal");
        }
        this.func = func;
        this.jacobian = jacobian;
    }

    @Override
    public int getN() {
        return this.func.getNumOfInputsN();
    }

    @Override
    public int getM() {
        return this.func.getNumOfOutputsM();
    }

    @Override
    public void setInput(double[] x) {
        this.x = x;
    }

    @Override
    public void computeFunctions(double[] output) {
        this.func.process(this.x, output);
    }

    @Override
    public void computeJacobian(double[] jacobian) {
        this.jacobian.process(this.x, jacobian);
    }
}

