/*
 * Decompiled with CFR 0.152.
 */
package mst;

import mst.StdIn;
import mst.StdOut;

public class UF {
    private int[] id;
    private int[] sz;
    private int count;

    public UF(int N) {
        if (N < 0) {
            throw new IllegalArgumentException();
        }
        this.count = N;
        this.id = new int[N];
        this.sz = new int[N];
        for (int i = 0; i < N; ++i) {
            this.id[i] = i;
            this.sz[i] = 1;
        }
    }

    public int find(int p) {
        if (p < 0 || p >= this.id.length) {
            throw new IndexOutOfBoundsException();
        }
        while (p != this.id[p]) {
            p = this.id[p];
        }
        return p;
    }

    public int count() {
        return this.count;
    }

    public boolean connected(int p, int q) {
        return this.find(p) == this.find(q);
    }

    public void union(int p, int q) {
        int j;
        int i = this.find(p);
        if (i == (j = this.find(q))) {
            return;
        }
        if (this.sz[i] < this.sz[j]) {
            this.id[i] = j;
            int n = j;
            this.sz[n] = this.sz[n] + this.sz[i];
        } else {
            this.id[j] = i;
            int n = i;
            this.sz[n] = this.sz[n] + this.sz[j];
        }
        --this.count;
    }

    public static void main(String[] args) {
        int N = StdIn.readInt();
        UF uf = new UF(N);
        while (!StdIn.isEmpty()) {
            int q;
            int p = StdIn.readInt();
            if (uf.connected(p, q = StdIn.readInt())) continue;
            uf.union(p, q);
            StdOut.println(p + " " + q);
        }
        StdOut.println(uf.count() + " components");
    }
}

