/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.conversion.AbstractConversion;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.cellfinder.AbstractCellFinder;
import adams.data.spreadsheet.cellfinder.CellLocation;
import adams.data.spreadsheet.cellfinder.SingleCell;
import java.util.ArrayList;
import java.util.Iterator;

public class SpreadSheetCellFinderToPositions
extends AbstractConversion {
    private static final long serialVersionUID = 4117708470154504868L;
    protected AbstractCellFinder m_CellFinder;

    public String globalInfo() {
        return "Turns the cells that the specified cell finder locates into an array of cell positions (like 'A2').";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("cell-finder", "cellFinder", (Object)new SingleCell());
    }

    public void setCellFinder(AbstractCellFinder value) {
        this.m_CellFinder = value;
        this.reset();
    }

    public AbstractCellFinder getCellFinder() {
        return this.m_CellFinder;
    }

    public String cellFinderTipText() {
        return "The cell finder to use.";
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"cellFinder", (Object)((Object)this.m_CellFinder), (String)"cell finder: ");
    }

    public Class accepts() {
        return SpreadSheet.class;
    }

    public Class generates() {
        return String[].class;
    }

    protected Object doConvert() throws Exception {
        SpreadSheet sheet = (SpreadSheet)this.m_Input;
        Iterator<CellLocation> cells = this.m_CellFinder.findCells(sheet);
        ArrayList<String> result = new ArrayList<String>();
        while (cells.hasNext()) {
            result.add(cells.next().toPosition());
        }
        return result.toArray(new String[result.size()]);
    }
}

