/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.core.option.OptionHandler;
import adams.core.option.OptionUtils;
import adams.data.conversion.AbstractConversion;
import adams.data.io.input.CsvSpreadSheetReader;
import adams.data.io.input.SpreadSheetReader;
import adams.data.spreadsheet.SpreadSheet;
import java.io.Reader;
import java.io.StringReader;

public class StringToSpreadSheet
extends AbstractConversion {
    private static final long serialVersionUID = 6345525457969386635L;
    protected SpreadSheetReader m_Reader;
    protected SpreadSheetReader m_ActualReader;

    public String globalInfo() {
        return "Turns a string representation of a spreadsheet into a SpreadSheet object, using the specified reader setup.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("reader", "reader", (Object)new CsvSpreadSheetReader());
    }

    protected void reset() {
        super.reset();
        this.m_ActualReader = null;
    }

    public void setReader(SpreadSheetReader value) {
        this.m_Reader = value;
        this.reset();
    }

    public SpreadSheetReader getReader() {
        return this.m_Reader;
    }

    public String readerTipText() {
        return "The reader setup to use for parsing the string.";
    }

    public Class accepts() {
        return String.class;
    }

    public Class generates() {
        return SpreadSheet.class;
    }

    protected Object doConvert() throws Exception {
        if (this.m_ActualReader == null) {
            this.m_ActualReader = (SpreadSheetReader)OptionUtils.shallowCopy((OptionHandler)this.m_Reader, (boolean)true);
        }
        return this.m_ActualReader.read((Reader)new StringReader((String)this.m_Input));
    }
}

