/*
 * Decompiled with CFR 0.152.
 */
package adams.data.io.output;

import adams.core.io.FileUtils;
import adams.data.io.output.AbstractSpreadSheetWriter;
import adams.data.io.output.MultiSheetSpreadSheetWriter;
import adams.data.spreadsheet.SpreadSheet;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.apache.commons.io.output.WriterOutputStream;

public abstract class AbstractMultiSheetSpreadSheetWriter
extends AbstractSpreadSheetWriter
implements MultiSheetSpreadSheetWriter {
    private static final long serialVersionUID = -9004877579871173007L;
    protected String m_SheetPrefix;

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("sheet-prefix", "sheetPrefix", (Object)this.getDefaultSheetPrefix());
    }

    protected String getDefaultSheetPrefix() {
        return "Sheet";
    }

    public void setSheetPrefix(String value) {
        this.m_SheetPrefix = value;
        this.reset();
    }

    public String getSheetPrefix() {
        return this.m_SheetPrefix;
    }

    public String sheetPrefixTipText() {
        return "The prefix for sheet names.";
    }

    public boolean canWriteMultiple() {
        return true;
    }

    protected boolean doWrite(SpreadSheet content, Writer writer) {
        return this.doWrite(new SpreadSheet[]{content}, writer);
    }

    protected boolean doWrite(SpreadSheet content, OutputStream out) {
        return this.doWrite(new SpreadSheet[]{content}, out);
    }

    protected boolean doWrite(SpreadSheet[] content, String filename) {
        return false;
    }

    protected boolean doWrite(SpreadSheet[] content, Writer writer) {
        return false;
    }

    protected boolean doWrite(SpreadSheet[] content, OutputStream out) {
        return false;
    }

    public boolean write(SpreadSheet[] content, File file) {
        return this.write(content, file.getAbsolutePath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean write(SpreadSheet[] content, String filename) {
        boolean result = true;
        BufferedWriter writer = null;
        Writer fw = null;
        OutputStream fos = null;
        try {
            switch (this.getOutputType()) {
                case FILE: {
                    result = this.doWrite(content, filename);
                    return result;
                }
                case STREAM: {
                    FileOutputStream output = new FileOutputStream(filename, false);
                    result = this.doWrite(content, (OutputStream)output);
                    return result;
                }
                case WRITER: {
                    writer = new BufferedWriter(new FileWriter(filename, false));
                    result = this.doWrite(content, (Writer)writer);
                    return result;
                }
                default: {
                    throw new IllegalStateException("Unhandled output type: " + this.getOutputType());
                }
            }
        }
        catch (Exception e) {
            result = false;
            e.printStackTrace();
            return result;
        }
        finally {
            FileUtils.closeQuietly(writer);
            FileUtils.closeQuietly(fw);
            FileUtils.closeQuietly(fos);
        }
    }

    public boolean write(SpreadSheet[] content, OutputStream stream) {
        switch (this.getOutputType()) {
            case FILE: {
                throw new IllegalStateException("Can only write to files!");
            }
            case STREAM: {
                return this.doWrite(content, stream);
            }
            case WRITER: {
                return this.doWrite(content, (Writer)new OutputStreamWriter(stream));
            }
        }
        throw new IllegalStateException("Unhandled output type: " + this.getOutputType());
    }

    public boolean write(SpreadSheet[] content, Writer writer) {
        switch (this.getOutputType()) {
            case FILE: {
                throw new IllegalStateException("Can only write to files!");
            }
            case STREAM: {
                return this.doWrite(content, (OutputStream)new WriterOutputStream(writer));
            }
            case WRITER: {
                return this.doWrite(content, writer);
            }
        }
        throw new IllegalStateException("Unhandled output type: " + this.getOutputType());
    }
}

