/*
 * Decompiled with CFR 0.152.
 */
package adams.data.spreadsheet.rowstatistic;

import adams.core.TechnicalInformation;
import adams.core.TechnicalInformationHandler;
import adams.data.spreadsheet.DataRow;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.rowstatistic.AbstractDoubleArrayRowStatistic;
import adams.data.statistics.StatUtils;

public class SignalToNoiseRatio
extends AbstractDoubleArrayRowStatistic
implements TechnicalInformationHandler {
    private static final long serialVersionUID = 330391755072250767L;

    public String globalInfo() {
        return "Calculates the signal to noise ratio for a numeric row.\nFor more information, see:\n" + this.getTechnicalInformation().toString();
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.MISC);
        result.setValue(TechnicalInformation.Field.AUTHOR, "WikiPedia");
        result.setValue(TechnicalInformation.Field.TITLE, "Signal-to-noise ratio");
        result.setValue(TechnicalInformation.Field.HTTP, "http://en.wikipedia.org/wiki/Signal-to-noise_ratio");
        return result;
    }

    @Override
    protected SpreadSheet postVisit(SpreadSheet sheet, int rowIndex) {
        SpreadSheet result = this.createOutputHeader();
        DataRow row = result.addRow();
        row.addCell(0).setContent("SNR");
        row.addCell(1).setContent(Double.valueOf(StatUtils.signalToNoiseRatio((double[])this.m_Values.toArray())));
        this.m_Values = null;
        return result;
    }
}

