/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.source;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.spreadsheet.DataRow;
import adams.data.spreadsheet.SpreadSheet;
import adams.flow.control.StorageName;
import adams.flow.core.Token;
import adams.flow.source.AbstractSimpleSource;
import adams.flow.transformer.LookUpInit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;

public class LookUpTable
extends AbstractSimpleSource {
    private static final long serialVersionUID = -4888807180866059350L;
    public static final String COLUMN_KEY = "Key";
    public static final String COLUMN_VALUE = "Value";
    protected StorageName m_StorageName;
    protected boolean m_UseNative;

    public String globalInfo() {
        return "Outputs the specified lookup table as spreadsheet, containing to columns: Key with the keys and Value with the associated values.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("storage-name", "storageName", (Object)new StorageName("lookup"));
        this.m_OptionManager.add("use-native", "useNative", (Object)false);
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"storageName", (Object)this.m_StorageName, (String)"storage: ");
        String value = QuickInfoHelper.toString((OptionHandler)this, (String)"useNative", (boolean)this.m_UseNative, (String)", native");
        if (value != null) {
            result = result + value;
        }
        return result;
    }

    public void setStorageName(StorageName value) {
        this.m_StorageName = value;
        this.reset();
    }

    public StorageName getStorageName() {
        return this.m_StorageName;
    }

    public String storageNameTipText() {
        return "The name of the lookup table in the internal storage.";
    }

    public Class[] generates() {
        return new Class[]{SpreadSheet.class};
    }

    public void setUseNative(boolean value) {
        this.m_UseNative = value;
        this.reset();
    }

    public boolean getUseNative() {
        return this.m_UseNative;
    }

    public String useNativeTipText() {
        return "If enabled, native objects are output rather than strings.";
    }

    protected String doExecute() {
        String result = null;
        if (!this.getStorageHandler().getStorage().has(this.m_StorageName)) {
            result = "Lookup table '" + this.m_StorageName + "' not available! Not initialized with " + LookUpInit.class.getName() + "?";
        } else {
            HashMap lookup = (HashMap)this.getStorageHandler().getStorage().get(this.m_StorageName);
            SpreadSheet sheet = new SpreadSheet();
            sheet.setName(this.m_StorageName.getValue());
            sheet.getHeaderRow().addCell("k").setContent(COLUMN_KEY);
            sheet.getHeaderRow().addCell("v").setContent(COLUMN_VALUE);
            ArrayList keys = new ArrayList(lookup.keySet());
            Collections.sort(keys);
            for (String key : keys) {
                DataRow row = sheet.addRow();
                row.addCell("k").setContent(key);
                if (this.m_UseNative) {
                    row.addCell("v").setNative(lookup.get(key));
                    continue;
                }
                row.addCell("v").setContent(lookup.get(key).toString());
            }
            this.m_OutputToken = new Token((Object)sheet);
        }
        return result;
    }
}

