/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.standalone.logevent;

import adams.core.base.BaseRegExp;
import adams.flow.standalone.logevent.AbstractLogRecordFilter;
import java.util.logging.LogRecord;

public class NameFilter
extends AbstractLogRecordFilter {
    private static final long serialVersionUID = 7462983936603453991L;
    protected BaseRegExp m_RegExp;

    public String globalInfo() {
        return "Filters records based on regular expression applied to logger name.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("regexp", "regExp", (Object)new BaseRegExp(".*"));
    }

    public void setRegExp(BaseRegExp value) {
        this.m_RegExp = value;
        this.reset();
    }

    public BaseRegExp getRegExp() {
        return this.m_RegExp;
    }

    public String regExpTipText() {
        return "The regular expression that the logger name must match.";
    }

    @Override
    public boolean acceptRecord(LogRecord record) {
        return this.m_RegExp.isMatch(record.getLoggerName());
    }
}

