/*
 * Decompiled with CFR 0.152.
 */
package moa.classifiers.core.driftdetection;

import moa.classifiers.core.driftdetection.AbstractChangeDetector;
import moa.classifiers.core.driftdetection.ChangeDetector;
import moa.core.ObjectRepository;
import moa.options.ClassOption;
import moa.options.IntOption;
import moa.options.ListOption;
import moa.options.MultiChoiceOption;
import moa.options.Option;
import moa.options.OptionHandler;
import moa.tasks.TaskMonitor;

public class EnsembleDriftDetectionMethods
extends AbstractChangeDetector {
    private static final long serialVersionUID = -3518369648142099719L;
    public IntOption minNumInstancesOption = new IntOption("minNumInstances", 'n', "The minimum number of instances before permitting detecting change.", 30, 0, Integer.MAX_VALUE);
    public ListOption changeDetectorsOption = new ListOption("changeDetectors", 'c', "Change Detectors to use.", new ClassOption("driftDetectionMethod", 'd', "Drift detection method to use.", ChangeDetector.class, "DDM"), new Option[0], ',');
    public MultiChoiceOption predictionOption = new MultiChoiceOption("prediction", 'l', "Prediction to use.", new String[]{"max", "min", "majority"}, new String[]{"Maximum", "Minimum", "Majority"}, 0);
    protected ChangeDetector[] cds;
    protected Boolean[] preds;

    public EnsembleDriftDetectionMethods() {
        this.resetLearning();
    }

    @Override
    public void resetLearning() {
        this.preds = new Boolean[this.changeDetectorsOption.getList().length];
        for (int i = 0; i < this.preds.length; ++i) {
            this.preds[i] = false;
        }
    }

    @Override
    public void input(double prediction) {
        for (int i = 0; i < this.cds.length; ++i) {
            this.cds[i].input(prediction);
            if (!this.cds[i].getChange()) continue;
            this.preds[i] = true;
        }
        int typePrediction = this.predictionOption.getChosenIndex();
        int numberDetections = 0;
        for (int i = 0; i < this.cds.length; ++i) {
            if (!this.preds[i].booleanValue()) continue;
            ++numberDetections;
        }
        if (typePrediction == 0) {
            this.isChangeDetected = numberDetections == this.cds.length;
        } else if (typePrediction == 1) {
            this.isChangeDetected = numberDetections > 0;
        } else if (typePrediction == 2) {
            boolean bl = this.isChangeDetected = numberDetections > this.cds.length / 2;
        }
        if (this.isChangeDetected) {
            this.resetLearning();
        }
    }

    @Override
    public void getDescription(StringBuilder sb, int indent) {
    }

    @Override
    protected void prepareForUseImpl(TaskMonitor monitor, ObjectRepository repository) {
        Option[] changeDetectorOptions = this.changeDetectorsOption.getList();
        this.cds = new ChangeDetector[changeDetectorOptions.length];
        this.preds = new Boolean[changeDetectorOptions.length];
        for (int i = 0; i < this.cds.length; ++i) {
            this.cds[i] = ((ChangeDetector)((ClassOption)changeDetectorOptions[i]).materializeObject(monitor, repository)).copy();
            if (monitor.taskShouldAbort()) {
                return;
            }
            if (this.cds[i] instanceof OptionHandler) {
                monitor.setCurrentActivity("Preparing change detector " + (i + 1) + "...", -1.0);
                this.cds[i].prepareForUse(monitor, repository);
                if (monitor.taskShouldAbort()) {
                    return;
                }
            }
            this.preds[i] = false;
        }
    }
}

