/*
 * Decompiled with CFR 0.152.
 */
package moa.classifiers.rules;

import moa.classifiers.Regressor;
import moa.classifiers.rules.AbstractAMRules;
import moa.classifiers.rules.core.Rule;
import moa.classifiers.rules.core.RuleActiveLearningNode;
import moa.classifiers.rules.core.RuleActiveRegressionNode;
import moa.classifiers.rules.core.voting.ErrorWeightedVote;
import moa.classifiers.rules.functions.Perceptron;
import moa.core.StringUtils;
import moa.options.ClassOption;
import moa.options.FlagOption;
import moa.options.FloatOption;
import moa.options.MultiChoiceOption;

public class AMRulesRegressor
extends AbstractAMRules
implements Regressor {
    private static final long serialVersionUID = 5988040868275521928L;
    public FlagOption constantLearningRatioDecayOption = new FlagOption("learningRatio_Decay_set_constant", 'd', "Learning Ratio Decay in Perceptron set to be constant. (The next parameter).");
    public FloatOption learningRatioOption = new FloatOption("learningRatio", 's', "Constante Learning Ratio to use for training the Perceptrons in the leaves.", 0.025);
    public MultiChoiceOption predictionFunctionOption = new MultiChoiceOption("predictionFunctionOption", 'P', "The prediction function to use.", new String[]{"Adaptative", "Perceptron", "Target Mean"}, new String[]{"Adaptative", "Perceptron", "Target Mean"}, 0);
    public ClassOption votingTypeOption = new ClassOption("votingType", 'V', "Voting Type.", ErrorWeightedVote.class, "InverseErrorWeightedVote");

    @Override
    protected Rule newRule(int ID, RuleActiveLearningNode node, double[] statistics) {
        double mean;
        Rule r = this.newRule(ID);
        if (node != null) {
            if (((RuleActiveRegressionNode)node).getPerceptron() != null) {
                ((RuleActiveRegressionNode)r.getLearningNode()).setPerceptron(new Perceptron(((RuleActiveRegressionNode)node).getPerceptron()));
                ((RuleActiveRegressionNode)r.getLearningNode()).getPerceptron().setLearningRatio(this.learningRatioOption.getValue());
            }
            if (statistics == null && node.getNodeStatistics().getValue(0) > 0.0) {
                mean = node.getNodeStatistics().getValue(1) / node.getNodeStatistics().getValue(0);
                ((RuleActiveRegressionNode)r.getLearningNode()).getTargetMean().reset(mean, 1L);
            }
        }
        if (statistics != null && ((RuleActiveRegressionNode)r.getLearningNode()).getTargetMean() != null && statistics[0] > 0.0) {
            mean = statistics[1] / statistics[0];
            ((RuleActiveRegressionNode)r.getLearningNode()).getTargetMean().reset(mean, (long)statistics[0]);
        }
        return r;
    }

    @Override
    public RuleActiveLearningNode newRuleActiveLearningNode(Rule.Builder builder) {
        return new RuleActiveRegressionNode(builder);
    }

    @Override
    public RuleActiveLearningNode newRuleActiveLearningNode(double[] initialClassObservations) {
        return new RuleActiveRegressionNode(initialClassObservations);
    }

    @Override
    public void getModelDescription(StringBuilder out, int indent) {
        super.getModelDescription(out, indent);
        StringUtils.appendIndented(out, indent, "The prediction function used: " + this.predictionFunctionOption.getChosenLabel());
        StringUtils.appendNewline(out);
    }

    @Override
    public void resetLearningImpl() {
        this.statistics = new double[]{0.0, 0.0, 0.0};
        this.ruleNumberID = 0;
        this.defaultRule = this.newRule(++this.ruleNumberID);
    }

    private Rule newRule(int ID) {
        Rule r = new Rule.Builder().threshold(this.pageHinckleyThresholdOption.getValue()).alpha(this.pageHinckleyAlphaOption.getValue()).changeDetection(this.DriftDetectionOption.isSet()).predictionFunction(this.predictionFunctionOption.getChosenIndex()).statistics(new double[3]).id(ID).amRules(this).build();
        r.getBuilder().setOwner(r);
        return r;
    }

    @Override
    public boolean isRandomizable() {
        return true;
    }

    @Override
    public ErrorWeightedVote newErrorWeightedVote() {
        return (ErrorWeightedVote)((Object)((ErrorWeightedVote)this.votingTypeOption.getPreMaterializedObject()).copy());
    }
}

