/*
 * Decompiled with CFR 0.152.
 */
package moa.classifiers.rules.functions;

import moa.classifiers.rules.functions.TargetMean;
import moa.options.FloatOption;
import weka.core.Instance;

public class FadingTargetMean
extends TargetMean {
    private static final long serialVersionUID = -1383391769242905972L;
    public FloatOption fadingFactorOption = new FloatOption("fadingFactor", 'f', "Fading factor for the FadingTargetMean accumulated error", 0.99, 0.0, 1.0);
    private double nD;
    private double fadingFactor;

    @Override
    public void trainOnInstanceImpl(Instance inst) {
        this.updateAccumulatedError(inst);
        this.nD = 1.0 + this.fadingFactor * this.nD;
        this.sum = inst.classValue() + this.fadingFactor * this.sum;
    }

    @Override
    public void resetLearningImpl() {
        super.resetLearningImpl();
        this.fadingFactor = this.fadingFactorOption.getValue();
    }

    @Override
    public double[] getVotesForInstance(Instance inst) {
        double[] currentMean = new double[]{this.nD > 0.0 ? this.sum / this.nD : 0.0};
        return currentMean;
    }
}

