/*
 * Decompiled with CFR 0.152.
 */
package moa.classifiers.trees;

import moa.classifiers.trees.HoeffdingTree;
import weka.core.Instance;

public class ASHoeffdingTree
extends HoeffdingTree {
    private static final long serialVersionUID = 1L;
    protected int maxSize = 10000;
    protected boolean resetTree = false;

    @Override
    public String getPurposeString() {
        return "Adaptive Size Hoeffding Tree used in Bagging using trees of different size.";
    }

    @Override
    public void resetLearningImpl() {
        this.treeRoot = null;
        this.decisionNodeCount = 0;
        this.activeLeafNodeCount = 0;
        this.inactiveLeafNodeCount = 0;
        this.inactiveLeafByteSizeEstimate = 0.0;
        this.activeLeafByteSizeEstimate = 0.0;
        this.byteSizeEstimateOverheadFraction = 1.0;
        this.growthAllowed = true;
    }

    @Override
    public void trainOnInstanceImpl(Instance inst) {
        if (this.treeRoot == null) {
            this.treeRoot = this.newLearningNode();
            this.activeLeafNodeCount = 1;
        }
        HoeffdingTree.FoundNode foundNode = this.treeRoot.filterInstanceToLeaf(inst, null, -1);
        HoeffdingTree.Node leafNode = foundNode.node;
        if (leafNode == null) {
            leafNode = this.newLearningNode();
            foundNode.parent.setChild(foundNode.parentBranch, leafNode);
            ++this.activeLeafNodeCount;
        }
        if (leafNode instanceof HoeffdingTree.LearningNode) {
            HoeffdingTree.ActiveLearningNode activeLearningNode;
            double weightSeen;
            HoeffdingTree.LearningNode learningNode = (HoeffdingTree.LearningNode)leafNode;
            learningNode.learnFromInstance(inst, this);
            if (this.growthAllowed && learningNode instanceof HoeffdingTree.ActiveLearningNode && (weightSeen = (activeLearningNode = (HoeffdingTree.ActiveLearningNode)learningNode).getWeightSeen()) - activeLearningNode.getWeightSeenAtLastSplitEvaluation() >= (double)this.gracePeriodOption.getValue()) {
                this.attemptToSplit(activeLearningNode, foundNode.parent, foundNode.parentBranch);
                while (this.decisionNodeCount >= this.maxSize && this.treeRoot instanceof HoeffdingTree.SplitNode) {
                    if (!this.resetTree) {
                        this.resizeTree(this.treeRoot, ((HoeffdingTree.SplitNode)this.treeRoot).instanceChildIndex(inst));
                        this.treeRoot = ((HoeffdingTree.SplitNode)this.treeRoot).getChild(((HoeffdingTree.SplitNode)this.treeRoot).instanceChildIndex(inst));
                        continue;
                    }
                    this.resetLearningImpl();
                }
                activeLearningNode.setWeightSeenAtLastSplitEvaluation(weightSeen);
            }
        }
        if (this.trainingWeightSeenByModel % (double)this.memoryEstimatePeriodOption.getValue() == 0.0) {
            this.estimateModelByteSizes();
        }
    }

    public void setMaxSize(int mSize) {
        this.maxSize = mSize;
    }

    public void setResetTree() {
        this.resetTree = true;
    }

    public void deleteNode(HoeffdingTree.Node node, int childIndex) {
        HoeffdingTree.Node child = ((HoeffdingTree.SplitNode)node).getChild(childIndex);
        if (child instanceof HoeffdingTree.SplitNode) {
            for (int branch = 0; branch < ((HoeffdingTree.SplitNode)child).numChildren(); ++branch) {
                this.deleteNode(child, branch);
            }
            --this.decisionNodeCount;
        } else if (child instanceof HoeffdingTree.InactiveLearningNode) {
            --this.inactiveLeafNodeCount;
        } else if (child instanceof HoeffdingTree.ActiveLearningNode) {
            --this.activeLeafNodeCount;
        }
        child = null;
    }

    public void resizeTree(HoeffdingTree.Node node, int childIndex) {
        if (node instanceof HoeffdingTree.SplitNode) {
            for (int branch = 0; branch < ((HoeffdingTree.SplitNode)node).numChildren(); ++branch) {
                if (branch == childIndex) continue;
                this.deleteNode(node, branch);
            }
        }
    }
}

