/*
 * Decompiled with CFR 0.152.
 */
package moa.clusterers.macro;

import java.util.List;
import java.util.Vector;
import moa.cluster.CFCluster;
import moa.cluster.Clustering;
import moa.clusterers.macro.IDenseMacroCluster;
import weka.core.Instance;

public class NonConvexCluster
extends CFCluster
implements IDenseMacroCluster {
    List<CFCluster> mMicroClusters = new Vector<CFCluster>();
    private static final long serialVersionUID = 1L;

    public NonConvexCluster(CFCluster cluster, List<CFCluster> microclusters) {
        super(cluster);
        this.mMicroClusters.addAll(microclusters);
        for (CFCluster cf : microclusters) {
            if (cf.equals(cluster)) continue;
            this.add(cf);
        }
    }

    @Override
    public CFCluster getCF() {
        return this;
    }

    public void insert(CFCluster cf) {
        this.mMicroClusters.add(cf);
    }

    public void remove(CFCluster cf) {
        this.mMicroClusters.remove(cf);
    }

    @Override
    public double getInclusionProbability(Instance instance) {
        double probability = 0.0;
        for (CFCluster cf : this.mMicroClusters) {
            probability = cf.getInclusionProbability(instance);
            if (!(probability > 0.0)) continue;
            return probability;
        }
        return probability;
    }

    @Override
    public double getRadius() {
        return 0.0;
    }

    @Override
    public Clustering getClustering() {
        Clustering c = new Clustering();
        for (CFCluster mc : this.mMicroClusters) {
            c.add(mc);
        }
        return c;
    }

    @Override
    public List<CFCluster> getMicroClusters() {
        return this.mMicroClusters;
    }
}

