/*
 * Decompiled with CFR 0.152.
 */
package moa.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import moa.core.AutoClassDiscovery;
import moa.core.AutoExpandVector;
import moa.gui.GUIUtils;
import moa.gui.OptionsConfigurationPanel;
import moa.options.ClassOption;
import moa.options.OptionHandler;
import moa.tasks.Task;

public class ClassOptionSelectionPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    protected JComboBox classChoiceBox;
    protected JComponent chosenObjectEditor;
    protected Object chosenObject;

    public ClassOptionSelectionPanel(Class<?> requiredType, String initialCLIString, String nullString) {
        Class<?>[] classesFound = this.findSuitableClasses(requiredType);
        this.classChoiceBox = new JComboBox(classesFound);
        this.setLayout(new BorderLayout());
        this.add((Component)this.classChoiceBox, "North");
        Object initialObject = null;
        try {
            initialObject = ClassOption.cliStringToObject(initialCLIString, requiredType, null);
        }
        catch (Exception ignored) {
            // empty catch block
        }
        if (initialObject != null) {
            this.classChoiceBox.setSelectedItem(initialObject.getClass());
            this.classChoiceChanged(initialObject);
        } else {
            try {
                Object chosen = ((Class)this.classChoiceBox.getSelectedItem()).newInstance();
                this.classChoiceChanged(chosen);
            }
            catch (Exception ex) {
                GUIUtils.showExceptionDialog(this, "Problem", ex);
            }
        }
        this.classChoiceBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    Object chosen = ((Class)ClassOptionSelectionPanel.this.classChoiceBox.getSelectedItem()).newInstance();
                    ClassOptionSelectionPanel.this.classChoiceChanged(chosen);
                }
                catch (Exception ex) {
                    GUIUtils.showExceptionDialog(ClassOptionSelectionPanel.this, "Problem", ex);
                }
            }
        });
    }

    public Class<?>[] findSuitableClasses(Class<?> requiredType) {
        Class[] tasksFound;
        Class[] classesFound;
        AutoExpandVector<Class> finalClasses = new AutoExpandVector<Class>();
        for (Class foundClass : classesFound = AutoClassDiscovery.findClassesOfType("moa", requiredType)) {
            finalClasses.add(foundClass);
        }
        for (Class foundTask : tasksFound = AutoClassDiscovery.findClassesOfType("moa", Task.class)) {
            try {
                Task task = (Task)foundTask.newInstance();
                if (!requiredType.isAssignableFrom(task.getTaskResultType())) continue;
                finalClasses.add(foundTask);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return finalClasses.toArray(new Class[finalClasses.size()]);
    }

    public static String showSelectClassDialog(Component parent, String title, Class<?> requiredType, String initialCLIString, String nullString) {
        ClassOptionSelectionPanel panel = new ClassOptionSelectionPanel(requiredType, initialCLIString, nullString);
        if (JOptionPane.showOptionDialog(parent, panel, title, 2, -1, null, null, null) == 0) {
            return panel.getChosenObjectCLIString(requiredType);
        }
        return initialCLIString;
    }

    public String getChosenObjectCLIString(Class<?> requiredType) {
        if (this.chosenObjectEditor instanceof OptionsConfigurationPanel) {
            ((OptionsConfigurationPanel)this.chosenObjectEditor).applyChanges();
        }
        return ClassOption.objectToCLIString(this.chosenObject, requiredType);
    }

    public void classChoiceChanged(Object chosen) {
        Container component;
        this.chosenObject = chosen;
        OptionsConfigurationPanel newChosenObjectEditor = null;
        if (this.chosenObject instanceof OptionHandler) {
            OptionHandler chosenOptionHandler = (OptionHandler)this.chosenObject;
            newChosenObjectEditor = new OptionsConfigurationPanel(chosenOptionHandler.getPurposeString(), chosenOptionHandler.getOptions());
        }
        if (this.chosenObjectEditor != null) {
            this.remove(this.chosenObjectEditor);
        }
        this.chosenObjectEditor = newChosenObjectEditor;
        if (this.chosenObjectEditor != null) {
            this.add((Component)this.chosenObjectEditor, "Center");
        }
        for (component = this; component != null && !(component instanceof JDialog); component = component.getParent()) {
        }
        if (component != null) {
            Window window = (Window)component;
            window.pack();
        }
    }
}

