/*
 * Decompiled with CFR 0.152.
 */
package moa.recommender.rc.utils;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import moa.recommender.rc.utils.Pair;
import moa.recommender.rc.utils.Vector;

public class DenseVector
extends Vector {
    private static final long serialVersionUID = -6077169543484777829L;
    private ArrayList<Double> list;

    public DenseVector() {
        this.list = new ArrayList();
    }

    public DenseVector(ArrayList<Double> list) {
        this.list = list;
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public void set(int index, double val) {
        while (index < this.list.size()) {
            this.list.add(0.0);
        }
        this.list.set(index, val);
    }

    @Override
    public void remove(int index) {
        this.list.remove(index);
    }

    @Override
    public Double get(int index) {
        if (index < 0 || index >= this.list.size()) {
            return null;
        }
        return this.list.get(index);
    }

    @Override
    public Set<Integer> getIdxs() {
        HashSet<Integer> keys = new HashSet<Integer>();
        for (int i = 0; i < this.list.size(); ++i) {
            keys.add(i);
        }
        return keys;
    }

    @Override
    public Vector copy() {
        return new DenseVector(new ArrayList<Double>(this.list));
    }

    @Override
    public Iterator<Pair<Integer, Double>> iterator() {
        return new DenseVectorIterator();
    }

    public class DenseVectorIterator
    implements Iterator<Pair<Integer, Double>> {
        private int index = 0;

        @Override
        public boolean hasNext() {
            return this.index < DenseVector.this.list.size();
        }

        @Override
        public Pair<Integer, Double> next() {
            return new Pair<Integer, Comparable>(this.index, (Comparable)DenseVector.this.list.get(this.index++));
        }

        @Override
        public void remove() {
            DenseVector.this.list.remove(this.index);
        }
    }
}

