/*
 * Decompiled with CFR 0.152.
 */
package adams.data.filter;

import adams.core.ClassCrossReference;
import adams.data.container.DataPoint;
import adams.data.filter.AbstractSAX;
import adams.data.filter.TimeseriesRowNorm;
import adams.data.statistics.TimeseriesStatistic;
import adams.data.timeseries.Timeseries;
import adams.data.timeseries.TimeseriesPoint;
import java.util.Date;

public class TimeseriesSAX
extends AbstractSAX<Timeseries>
implements ClassCrossReference {
    private static final long serialVersionUID = 1836858988505886282L;

    public String globalInfo() {
        return "Performs Symbolic Aggregate approXimation (SAX).\nThe data must be normalized using " + TimeseriesRowNorm.class.getName() + " beforehand.\n" + "For more information see:\n\n" + this.getTechnicalInformation().toString();
    }

    public Class[] getClassCrossReferences() {
        return new Class[]{TimeseriesRowNorm.class};
    }

    protected double getMeanDeltaX(Timeseries data) {
        TimeseriesStatistic<Timeseries> stats = new TimeseriesStatistic<Timeseries>(data);
        return stats.getStatistic("mean delta Timestamp");
    }

    protected double getX(DataPoint point) {
        return ((TimeseriesPoint)point).getTimestamp().getTime();
    }

    protected double getY(DataPoint point) {
        return ((TimeseriesPoint)point).getValue();
    }

    protected DataPoint newDataPoint(double x, double y) {
        return new TimeseriesPoint(new Date((long)x), y);
    }
}

