/*
 * Decompiled with CFR 0.152.
 */
package adams.data.io.output;

import adams.data.io.output.AbstractTimeseriesWriter;
import adams.data.io.output.CsvSpreadSheetWriter;
import adams.data.io.output.MetaFileWriter;
import adams.data.io.output.MultiSheetSpreadSheetWriter;
import adams.data.io.output.SpreadSheetWriter;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.timeseries.Timeseries;
import java.io.File;
import java.util.List;

public class SpreadSheetTimeseriesWriter
extends AbstractTimeseriesWriter
implements MetaFileWriter {
    private static final long serialVersionUID = -1167695200549050674L;
    protected SpreadSheetWriter m_Writer;

    public String globalInfo() {
        return "Writes timeseries data using a spreadsheet writer.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("writer", "writer", (Object)new CsvSpreadSheetWriter());
    }

    public String getFormatDescription() {
        return "Spreadsheet timeseries";
    }

    public String[] getFormatExtensions() {
        return new String[]{"*"};
    }

    public String[] getActualFormatExtensions() {
        return this.m_Writer.getFormatExtensions();
    }

    public void setWriter(SpreadSheetWriter value) {
        this.m_Writer = value;
        this.reset();
    }

    public SpreadSheetWriter getWriter() {
        return this.m_Writer;
    }

    public String writerTipText() {
        return "The writer to use for writing the spreadsheet file.";
    }

    @Override
    public boolean canWriteMultiple() {
        if (this.m_Writer instanceof MultiSheetSpreadSheetWriter) {
            return ((MultiSheetSpreadSheetWriter)this.m_Writer).canWriteMultiple();
        }
        return false;
    }

    protected boolean writeData(List<Timeseries> data) {
        SpreadSheet[] sheets = new SpreadSheet[data.size()];
        for (int i = 0; i < data.size(); ++i) {
            sheets[i] = data.get(i).toSpreadSheet();
        }
        if (this.m_Writer instanceof MultiSheetSpreadSheetWriter) {
            return ((MultiSheetSpreadSheetWriter)this.m_Writer).write(sheets, (File)this.m_Output);
        }
        return this.m_Writer.write(sheets[0], (File)this.m_Output);
    }
}

