/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.timeseries.Timeseries;
import adams.flow.transformer.AbstractArrayProvider;
import adams.flow.transformer.timeseriessplit.AbstractTimeseriesSplitter;
import adams.flow.transformer.timeseriessplit.PassThrough;
import java.util.Arrays;

public class TimeseriesSplit
extends AbstractArrayProvider {
    private static final long serialVersionUID = -3019442578354930841L;
    protected AbstractTimeseriesSplitter m_Splitter;

    public String globalInfo() {
        return "Splits the incoming timeseries into sub-series using the specified splitter algorithm.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("splitter", "splitter", (Object)new PassThrough());
    }

    public String outputArrayTipText() {
        return "If enabled, the sub-series are output as array rather than one-by-one.";
    }

    public void setSplitter(AbstractTimeseriesSplitter value) {
        this.m_Splitter = value;
        this.reset();
    }

    public AbstractTimeseriesSplitter getSplitter() {
        return this.m_Splitter;
    }

    public String splitterTipText() {
        return "The splitting algorithm to use.";
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"splitter", (Object)((Object)this.m_Splitter), (String)"splitter: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"outputArray", (boolean)this.m_OutputArray, (String)"as array", (String)", ");
        return result;
    }

    public Class[] accepts() {
        return new Class[]{Timeseries.class};
    }

    protected Class getItemClass() {
        return Timeseries.class;
    }

    protected String doExecute() {
        String result = null;
        Timeseries series = (Timeseries)((Object)this.m_InputToken.getPayload());
        this.m_Queue.clear();
        try {
            Timeseries[] sub = this.m_Splitter.split(series);
            this.m_Queue.addAll(Arrays.asList(sub));
        }
        catch (Exception e) {
            result = this.handleException("Failed to split timeseries", e);
        }
        return result;
    }
}

