/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.timeseries;

import adams.core.base.BaseDateTime;
import adams.gui.event.PaintEvent;
import adams.gui.visualization.core.AxisPanel;
import adams.gui.visualization.core.plot.Axis;
import adams.gui.visualization.timeseries.AbstractTimeseriesPaintlet;
import java.awt.Color;
import java.awt.Graphics;
import java.util.Date;

public class FixedTimestampPaintlet
extends AbstractTimeseriesPaintlet {
    private static final long serialVersionUID = 4296847364394457330L;
    protected BaseDateTime m_Timestamp;
    protected String m_Prefix;
    protected int m_OffsetY;
    protected int m_OffsetX;
    protected Color m_Color;

    public String globalInfo() {
        return "Paintlet for highlighting a specific timestamp with a vertical indicator line.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("timestamp", "timestamp", (Object)new BaseDateTime("NOW"));
        this.m_OptionManager.add("prefix", "prefix", (Object)"");
        this.m_OptionManager.add("offset-x", "offsetX", (Object)10);
        this.m_OptionManager.add("offset-y", "offsetY", (Object)10, (Number)0, null);
        this.m_OptionManager.add("color", "color", (Object)Color.RED);
    }

    public void setTimestamp(BaseDateTime value) {
        this.m_Timestamp = value;
        this.memberChanged();
    }

    public BaseDateTime getTimestamp() {
        return this.m_Timestamp;
    }

    public String timestampTipText() {
        return "The timestamp to indicate.";
    }

    public void setPrefix(String value) {
        if (value != this.m_Prefix || value != null && !value.equals(this.m_Prefix)) {
            this.m_Prefix = value;
            this.memberChanged();
        }
    }

    public String getPrefix() {
        return this.m_Prefix;
    }

    public String prefixTipText() {
        return "The prefix to use for the date label printed next to the indicator.";
    }

    public void setOffsetX(int value) {
        if (value != this.m_OffsetX) {
            this.m_OffsetX = value;
            this.memberChanged();
        }
    }

    public int getOffsetX() {
        return this.m_OffsetX;
    }

    public String offsetXTipText() {
        return "The number of pixels to offset the string from the left of the indicator.";
    }

    public void setOffsetY(int value) {
        if (value != this.m_OffsetY && value >= 0) {
            this.m_OffsetY = value;
            this.memberChanged();
        }
    }

    public int getOffsetY() {
        return this.m_OffsetY;
    }

    public String offsetYTipText() {
        return "The number of pixels to offset the string from the top of the panel.";
    }

    public void setColor(Color value) {
        if (value != this.m_Color || value != null && !value.equals(this.m_Color)) {
            this.m_Color = value;
            this.memberChanged();
        }
    }

    public Color getColor() {
        return this.m_Color;
    }

    public String colorTipText() {
        return "The color of the indicator/text.";
    }

    public PaintEvent.PaintMoment getPaintMoment() {
        return PaintEvent.PaintMoment.POST_PAINT;
    }

    public void performPaint(Graphics g, PaintEvent.PaintMoment moment) {
        Date date = this.m_Timestamp.dateValue();
        AxisPanel axisX = this.getPanel().getPlot().getAxis(Axis.BOTTOM);
        g.setColor(this.m_Color);
        g.drawLine(axisX.valueToPos((double)date.getTime()), 0, axisX.valueToPos((double)date.getTime()), this.getPanel().getHeight());
        g.drawString(this.m_Prefix + axisX.valueToDisplay((double)date.getTime()), axisX.valueToPos((double)date.getTime()) + this.m_OffsetX, this.m_OffsetY);
    }
}

