/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.timeseries;

import adams.core.DateUtils;
import adams.core.base.BaseDateTime;
import adams.gui.core.ColorHelper;
import adams.gui.event.PaintEvent;
import adams.gui.visualization.core.AxisPanel;
import adams.gui.visualization.core.axis.FlippableAxisModel;
import adams.gui.visualization.core.plot.Axis;
import adams.gui.visualization.timeseries.AbstractTimeseriesPaintlet;
import java.awt.Color;
import java.awt.Graphics;
import java.util.Date;

public class FixedTimestampRangePaintlet
extends AbstractTimeseriesPaintlet {
    private static final long serialVersionUID = 4296847364394457330L;
    protected BaseDateTime m_StartTimestamp;
    protected BaseDateTime m_EndTimestamp;
    protected Color m_Color;

    public String globalInfo() {
        return "Paintlet for highlighting a specific timestamp range with a background color.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("start-timestamp", "startTimestamp", (Object)new BaseDateTime("NOW"));
        this.m_OptionManager.add("end-timestamp", "endTimestamp", (Object)new BaseDateTime("NOW"));
        this.m_OptionManager.add("color", "color", (Object)ColorHelper.valueOf((String)"#D8D8D8"));
    }

    public void setStartTimestamp(BaseDateTime value) {
        this.m_StartTimestamp = value;
        this.memberChanged();
    }

    public BaseDateTime getStartTimestamp() {
        return this.m_StartTimestamp;
    }

    public String startTimestampTipText() {
        return "The timestamp indicating the start of the range.";
    }

    public void setEndTimestamp(BaseDateTime value) {
        this.m_EndTimestamp = value;
        this.memberChanged();
    }

    public BaseDateTime getEndTimestamp() {
        return this.m_EndTimestamp;
    }

    public String endTimestampTipText() {
        return "The timestamp indicating the end of the range.";
    }

    public void setColor(Color value) {
        if (value != this.m_Color || value != null && !value.equals(this.m_Color)) {
            this.m_Color = value;
            this.memberChanged();
        }
    }

    public Color getColor() {
        return this.m_Color;
    }

    public String colorTipText() {
        return "The color of the selected range.";
    }

    public PaintEvent.PaintMoment getPaintMoment() {
        return PaintEvent.PaintMoment.BACKGROUND;
    }

    public void performPaint(Graphics g, PaintEvent.PaintMoment moment) {
        boolean flipped;
        Date startDate = this.m_StartTimestamp.dateValue();
        Date endDate = this.m_EndTimestamp.dateValue();
        AxisPanel axisX = this.getPanel().getPlot().getAxis(Axis.BOTTOM);
        boolean bl = flipped = axisX.getAxisModel() instanceof FlippableAxisModel && ((FlippableAxisModel)axisX.getAxisModel()).isFlipped();
        if (startDate != null && endDate != null) {
            if (DateUtils.isBefore((Date)startDate, (Date)endDate)) {
                startDate = this.m_EndTimestamp.dateValue();
                endDate = this.m_StartTimestamp.dateValue();
            }
            g.setColor(this.getColor());
            if (flipped) {
                g.fillRect(axisX.valueToPos((double)endDate.getTime()), 0, axisX.valueToPos((double)startDate.getTime()) - axisX.valueToPos((double)endDate.getTime()), this.getPanel().getHeight());
            } else {
                g.fillRect(axisX.valueToPos((double)startDate.getTime()), 0, axisX.valueToPos((double)endDate.getTime()) - axisX.valueToPos((double)startDate.getTime()), this.getPanel().getHeight());
            }
        }
    }
}

