/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.timeseries;

import adams.core.option.OptionUtils;
import adams.data.DateFormatString;
import adams.data.baseline.AbstractBaselineCorrection;
import adams.data.baseline.TimeseriesLOWESSBased;
import adams.data.container.DataContainer;
import adams.data.container.DataPoint;
import adams.data.conversion.TimeseriesToWekaInstances;
import adams.data.conversion.WekaInstancesToTimeseries;
import adams.data.timeseries.Timeseries;
import adams.data.timeseries.TimeseriesPoint;
import adams.data.timeseries.TimeseriesUtils;
import adams.data.weka.WekaAttributeIndex;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import weka.classifiers.evaluation.NumericPrediction;
import weka.classifiers.timeseries.AbstractForecaster;
import weka.classifiers.timeseries.WekaForecaster;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Utils;

public class BaselineAdjustedForecaster
extends AbstractForecaster
implements Serializable,
OptionHandler {
    private static final long serialVersionUID = 3169376392576809182L;
    protected AbstractBaselineCorrection m_Correction;
    protected AbstractForecaster m_Baseline;
    protected AbstractForecaster m_Periodicity;
    protected boolean m_ModelBuilt;

    public BaselineAdjustedForecaster() {
        this.initialize();
        this.reset();
    }

    public String globalInfo() {
        return "Uses two base-forecasters for making predictions. The first one is trained on the baseline of the timeseries (= overall trend), the second is trained on the baseline-corrected data (= periodicity). At forecast time, the two predictions are super-imposed to generate the original signal again.";
    }

    public String getAlgorithmName() {
        return OptionUtils.getShortCommandLine((Object)this);
    }

    protected void initialize() {
        this.m_Correction = new TimeseriesLOWESSBased();
        this.m_Baseline = new WekaForecaster();
        this.m_Periodicity = new WekaForecaster();
    }

    public void reset() {
        this.m_ModelBuilt = false;
        this.m_Correction.cleanUp();
        this.m_Baseline.reset();
        this.m_Periodicity.reset();
    }

    public Enumeration listOptions() {
        Vector<Option> result = new Vector<Option>();
        result.addElement(new Option("\tThe baseline correction scheme.\n\t(default: " + TimeseriesLOWESSBased.class.getName() + ")", "correction", 1, "-correction <classname+options>"));
        result.addElement(new Option("\tThe baseline forecaster.\n\t(default: " + WekaForecaster.class.getName() + ")", "baseline", 1, "-baseline <classname+options>"));
        result.addElement(new Option("\tThe periodicity forecaster.\n\t(default: " + WekaForecaster.class.getName() + ")", "periodicity", 1, "-periodicity <classname+options>"));
        return result.elements();
    }

    public void setOptions(String[] options) throws Exception {
        this.reset();
        String tmpStr = Utils.getOption((String)"correction", (String[])options);
        if (tmpStr.isEmpty()) {
            this.setCorrection((AbstractBaselineCorrection)new TimeseriesLOWESSBased());
        } else {
            this.setCorrection(AbstractBaselineCorrection.forCommandLine((String)tmpStr));
        }
        tmpStr = Utils.getOption((String)"baseline", (String[])options);
        if (tmpStr.isEmpty()) {
            this.setBaseline((AbstractForecaster)new WekaForecaster());
        } else {
            this.setBaseline((AbstractForecaster)OptionUtils.forAnyCommandLine(AbstractForecaster.class, (String)tmpStr));
        }
        tmpStr = Utils.getOption((String)"periodicity", (String[])options);
        if (tmpStr.isEmpty()) {
            this.setPeriodicity((AbstractForecaster)new WekaForecaster());
        } else {
            this.setPeriodicity((AbstractForecaster)OptionUtils.forAnyCommandLine(AbstractForecaster.class, (String)tmpStr));
        }
    }

    public String[] getOptions() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("-correction");
        result.add(OptionUtils.getCommandLine((Object)this.m_Correction));
        result.add("-baseline");
        result.add(OptionUtils.getCommandLine((Object)this.m_Baseline));
        result.add("-periodicity");
        result.add(OptionUtils.getCommandLine((Object)this.m_Periodicity));
        return result.toArray(new String[result.size()]);
    }

    public void setCorrection(AbstractBaselineCorrection value) {
        this.m_Correction = value;
        this.reset();
    }

    public AbstractBaselineCorrection getCorrection() {
        return this.m_Correction;
    }

    public String correctionTipText() {
        return "The baseline correction scheme to use.";
    }

    public void setBaseline(AbstractForecaster value) {
        this.m_Baseline = value;
        this.reset();
    }

    public AbstractForecaster getBaseline() {
        return this.m_Baseline;
    }

    public String baselineTipText() {
        return "The forecaster to use for the baseline.";
    }

    public void setPeriodicity(AbstractForecaster value) {
        this.m_Periodicity = value;
        this.reset();
    }

    public AbstractForecaster getPeriodicity() {
        return this.m_Periodicity;
    }

    public String periodicityTipText() {
        return "The forecaster to use for the periodicity.";
    }

    protected Timeseries instancesToTimeseries(Instances insts) throws Exception {
        WekaInstancesToTimeseries toTime = new WekaInstancesToTimeseries();
        if (insts.attribute(0).isDate()) {
            toTime.setDateAttribute(new WekaAttributeIndex("1"));
            toTime.setValueAttribute(new WekaAttributeIndex("2"));
        } else {
            toTime.setDateAttribute(new WekaAttributeIndex("2"));
            toTime.setValueAttribute(new WekaAttributeIndex("1"));
        }
        toTime.setInput(insts);
        String msg = toTime.convert();
        if (msg != null) {
            throw new Exception("Converting instances to timeseries failed: " + msg);
        }
        Timeseries result = (Timeseries)((Object)toTime.getOutput());
        toTime.cleanUp();
        return result;
    }

    protected Instances timeseriesToInstances(Timeseries series) throws Exception {
        TimeseriesToWekaInstances fromTime = new TimeseriesToWekaInstances();
        fromTime.setFormat(new DateFormatString("yyyy-MM-dd HH:mm:ss.S"));
        fromTime.setInput((Object)series);
        String msg = fromTime.convert();
        if (msg != null) {
            throw new Exception("Converting timeseries to instances failed: " + msg);
        }
        Instances result = (Instances)fromTime.getOutput();
        fromTime.cleanUp();
        return result;
    }

    protected Timeseries extractBaseline(Timeseries raw, Timeseries corrected) {
        Timeseries result = raw.getHeader();
        for (int i = 0; i < corrected.size(); ++i) {
            TimeseriesPoint corr = (TimeseriesPoint)((Object)corrected.toList().get(i));
            int index = TimeseriesUtils.findClosestTimestamp(raw.toList(), corr.getTimestamp());
            if (index <= -1) continue;
            result.add((DataPoint)((TimeseriesPoint)((Object)raw.toList().get(index))));
        }
        return result;
    }

    public void buildForecaster(Instances insts, PrintStream ... progress) throws Exception {
        if (insts.numAttributes() > 2) {
            throw new IllegalArgumentException("Data must contain two attributes (timestamp, value), encountered: " + insts.numAttributes());
        }
        if (!insts.checkForAttributeType(3)) {
            throw new IllegalArgumentException("Data must contain a date attribute, none found!");
        }
        if (!insts.checkForAttributeType(0)) {
            throw new IllegalArgumentException("Data must contain a numeric attribute, none found!");
        }
        Timeseries raw = this.instancesToTimeseries(insts);
        Timeseries corrected = (Timeseries)this.m_Correction.correct((DataContainer)raw);
        Timeseries baseline = this.extractBaseline(raw, corrected);
        Instances baselineInst = this.timeseriesToInstances(baseline);
        this.m_Baseline.buildForecaster(baselineInst, progress);
        Instances correctedInst = this.timeseriesToInstances(corrected);
        this.m_Periodicity.buildForecaster(correctedInst, progress);
        this.m_ModelBuilt = true;
    }

    public void primeForecaster(Instances insts) throws Exception {
        if (!this.m_ModelBuilt) {
            throw new IllegalStateException("No model built!");
        }
        Timeseries raw = this.instancesToTimeseries(insts);
        Timeseries corrected = (Timeseries)this.m_Correction.correct((DataContainer)raw);
        Timeseries baseline = this.extractBaseline(raw, corrected);
        Instances baselineInst = this.timeseriesToInstances(baseline);
        this.m_Baseline.primeForecaster(baselineInst);
        Instances correctedInst = this.timeseriesToInstances(corrected);
        this.m_Periodicity.primeForecaster(correctedInst);
    }

    public List<List<NumericPrediction>> forecast(int numSteps, PrintStream ... progress) throws Exception {
        if (!this.m_ModelBuilt) {
            throw new IllegalStateException("No model built!");
        }
        List baseline = this.m_Baseline.forecast(numSteps, progress);
        List periodicity = this.m_Periodicity.forecast(numSteps, progress);
        ArrayList<List<NumericPrediction>> result = new ArrayList<List<NumericPrediction>>();
        for (int i = 0; i < baseline.size(); ++i) {
            result.add(new ArrayList());
            for (int n = 0; n < ((List)baseline.get(i)).size(); ++n) {
                double predicted = ((NumericPrediction)((List)baseline.get(i)).get(n)).predicted() + ((NumericPrediction)((List)periodicity.get(i)).get(n)).predicted();
                double actual = ((NumericPrediction)((List)baseline.get(i)).get(n)).actual() + ((NumericPrediction)((List)periodicity.get(i)).get(n)).actual();
                NumericPrediction pred = new NumericPrediction(actual, predicted);
                ((List)result.get(result.size() - 1)).add(pred);
            }
        }
        return result;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        if (!this.m_ModelBuilt) {
            result.append("Forecaster has not been built yet!");
        } else {
            result.append("Baseline forecaster:\n\n" + this.m_Baseline);
            result.append("\n\n");
            result.append("Periodicity forecaster:\n\n" + this.m_Periodicity);
        }
        return result.toString();
    }
}

