/*
 * Decompiled with CFR 0.152.
 */
package meka.classifiers.multilabel;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import meka.classifiers.multilabel.MultilabelClassifier;
import meka.core.A;
import weka.classifiers.AbstractClassifier;
import weka.classifiers.Classifier;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.Randomizable;
import weka.core.RevisionUtils;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;

public class CDN
extends MultilabelClassifier
implements Randomizable,
TechnicalInformationHandler {
    private static final long serialVersionUID = -4571133392057899417L;
    protected Classifier[] h = null;
    protected Random u = null;
    protected Instances[] D_templates;
    protected int I = 1000;
    protected int I_c = 100;
    protected int m_S = 0;

    @Override
    public void buildClassifier(Instances D) throws Exception {
        this.testCapabilities(D);
        int N = D.numInstances();
        int L = D.classIndex();
        this.h = new Classifier[L];
        this.u = new Random(this.m_S);
        this.D_templates = new Instances[L];
        for (int j = 0; j < L; ++j) {
            this.D_templates[j] = new Instances(D);
            this.D_templates[j].setClassIndex(j);
            this.h[j] = AbstractClassifier.forName((String)this.getClassifier().getClass().getName(), (String[])((AbstractClassifier)this.getClassifier()).getOptions());
            this.h[j].buildClassifier(this.D_templates[j]);
        }
    }

    @Override
    public double[] distributionForInstance(Instance x) throws Exception {
        int L = x.classIndex();
        double[] y = new double[L];
        int[] sequence = A.make_sequence(L);
        double[] likelihood = new double[L];
        for (int i = 0; i < this.I; ++i) {
            Collections.shuffle(Arrays.asList(new int[][]{sequence}));
            for (int j : sequence) {
                x.setDataset(this.D_templates[j]);
                double[] dist = this.h[j].distributionForInstance(x);
                int k = A.samplePMF(dist, this.u);
                x.setValue(j, (double)k);
                likelihood[j] = dist[k];
                double s = Utils.sum((double[])likelihood);
                if (i <= this.I - this.I_c) continue;
                int n = j;
                y[n] = y[n] + x.value(j);
            }
        }
        int j = 0;
        while (j < L) {
            int n = j++;
            y[n] = y[n] / (double)this.I_c;
        }
        return y;
    }

    public void setSeed(int s) {
        this.m_S = s;
    }

    public int getSeed() {
        return this.m_S;
    }

    public String seedTipText() {
        return "The seed value for randomization.";
    }

    public int getI() {
        return this.I;
    }

    public void setI(int i) {
        this.I = i;
    }

    public int getIc() {
        return this.I_c;
    }

    public void setIc(int ic) {
        this.I_c = ic;
    }

    public Enumeration listOptions() {
        Vector<Object> newVector = new Vector<Object>();
        newVector.addElement(new Option("\tTotal Iterations.\n\tdefault: " + this.I, "I", 1, "-I <value>"));
        newVector.addElement(new Option("\tCollection Iterations.\n\tdefault: " + this.I_c, "Ic", 1, "-Ic <value>"));
        Enumeration enu = super.listOptions();
        while (enu.hasMoreElements()) {
            newVector.addElement(enu.nextElement());
        }
        return newVector.elements();
    }

    public void setOptions(String[] options) throws Exception {
        this.I = Utils.getOptionPos((char)'I', (String[])options) >= 0 ? Integer.parseInt(Utils.getOption((char)'I', (String[])options)) : this.I;
        this.I_c = Utils.getOptionPos((String)"Ic", (String[])options) >= 0 ? Integer.parseInt(Utils.getOption((String)"Ic", (String[])options)) : this.I_c;
        super.setOptions(options);
    }

    public String[] getOptions() {
        ArrayList<String> result = new ArrayList<String>(Arrays.asList(super.getOptions()));
        result.add("-I");
        result.add("" + this.I);
        result.add("-Ic");
        result.add("" + this.I_c);
        return result.toArray(new String[result.size()]);
    }

    public static void main(String[] args) {
        MultilabelClassifier.evaluation(new CDN(), args);
    }

    @Override
    public String globalInfo() {
        return "A Conditional Dependency Network. For more information see:\n" + this.getTechnicalInformation().toString();
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.ARTICLE);
        result.setValue(TechnicalInformation.Field.AUTHOR, "Yuhong Guoand and Suicheng Gu");
        result.setValue(TechnicalInformation.Field.TITLE, "Multi-Label Classification Using Conditional Dependency Networks");
        result.setValue(TechnicalInformation.Field.BOOKTITLE, "IJCAI '11");
        result.setValue(TechnicalInformation.Field.YEAR, "2011");
        return result;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract((String)"$Revision: 9117 $");
    }
}

