/*
 * Decompiled with CFR 0.152.
 */
package meka.classifiers.multilabel;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import meka.classifiers.multilabel.CDN;
import meka.classifiers.multilabel.CT;
import meka.classifiers.multilabel.MultilabelClassifier;
import meka.classifiers.multilabel.cc.CNode;
import meka.classifiers.multilabel.cc.Trellis;
import meka.core.A;
import meka.core.StatUtils;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.RevisionUtils;
import weka.core.TechnicalInformation;
import weka.core.Utils;

public class CDT
extends CDN {
    protected int m_Width = -1;
    protected int m_Connectivity = 1;
    protected String m_DependencyPayoff = "_";
    Trellis trel = null;
    protected CNode[] nodes = null;

    @Override
    public void buildClassifier(Instances D) throws Exception {
        this.testCapabilities(D);
        int L = D.classIndex();
        int d = D.numAttributes() - L;
        this.u = new Random(this.getSeed());
        if (this.m_Width < 0) {
            this.m_Width = (int)Math.sqrt(L);
        }
        this.nodes = new CNode[L];
        if (this.getDebug()) {
            System.out.println("Make Trellis of width " + this.m_Width);
        }
        int[] indices = A.make_sequence(L);
        A.shuffle(indices, new Random(this.getSeed()));
        this.trel = new Trellis(indices, this.m_Width, this.m_Connectivity);
        if (this.getDebug()) {
            System.out.println("==>\n" + this.trel.toString());
        }
        if (!this.m_DependencyPayoff.equals("_")) {
            this.trel = CT.orderTrellis(this.trel, StatUtils.margDepMatrix(D, this.m_DependencyPayoff), this.u);
        }
        if (this.getDebug()) {
            System.out.println("Build Trellis");
        }
        if (this.getDebug()) {
            System.out.println("nodes: " + Arrays.toString(this.trel.indices));
        }
        for (int j = 0; j < L; ++j) {
            int jv = this.trel.indices[j];
            if (this.getDebug()) {
                System.out.println("Build Node h_" + jv + "] : P(y_" + jv + " | x_[1:d], y_" + Arrays.toString(this.trel.getNeighbours(j)) + ")");
            }
            this.nodes[jv] = new CNode(jv, null, this.trel.getNeighbours(j));
            this.nodes[jv].build(D, this.m_Classifier);
        }
    }

    @Override
    public double[] distributionForInstance(Instance x) throws Exception {
        int L = x.classIndex();
        double[] y = new double[L];
        double[] y_marg = new double[L];
        int[] sequence = A.make_sequence(L);
        double[] likelihood = new double[L];
        for (int i = 0; i < this.I; ++i) {
            Collections.shuffle(Arrays.asList(new int[][]{sequence}));
            for (int j : sequence) {
                y[j] = this.nodes[j].sample(x, y, this.u);
                if (i <= this.I - this.I_c) continue;
                int n = j;
                y_marg[n] = y_marg[n] + y[j];
            }
        }
        int j = 0;
        while (j < L) {
            int n = j++;
            y_marg[n] = y_marg[n] / (double)this.I_c;
        }
        return y_marg;
    }

    @Override
    public Enumeration listOptions() {
        Vector<Object> newVector = new Vector<Object>();
        newVector.addElement(new Option("\tThe width of the trellis.\n\tdefault: " + this.m_Width, "H", 1, "-H <value>"));
        newVector.addElement(new Option("\tThe density/type of the trellis.\n\tdefault: " + this.m_Connectivity + "\n\trange: 0-3 (0=BR)", "L", 1, "-L <value>"));
        newVector.addElement(new Option("\tThe dependency payoff function.\n\tdefault: " + this.m_DependencyPayoff + "(random)\n\t", "X", 1, "-X <value>"));
        Enumeration enu = super.listOptions();
        while (enu.hasMoreElements()) {
            newVector.addElement(enu.nextElement());
        }
        return newVector.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        this.m_Width = Utils.getOptionPos((char)'H', (String[])options) >= 0 ? Integer.parseInt(Utils.getOption((char)'H', (String[])options)) : this.m_Width;
        this.m_Connectivity = Utils.getOptionPos((char)'L', (String[])options) >= 0 ? Integer.parseInt(Utils.getOption((char)'L', (String[])options)) : this.m_Connectivity;
        this.m_DependencyPayoff = Utils.getOptionPos((char)'X', (String[])options) >= 0 ? Utils.getOption((char)'X', (String[])options) : this.m_DependencyPayoff;
        super.setOptions(options);
    }

    @Override
    public String[] getOptions() {
        ArrayList<String> result = new ArrayList<String>(Arrays.asList(super.getOptions()));
        result.add("-H");
        result.add("" + this.m_Width);
        result.add("-L");
        result.add("" + this.m_Connectivity);
        result.add("-P");
        result.add("" + this.m_DependencyPayoff);
        return result.toArray(new String[result.size()]);
    }

    public int getType() {
        return this.m_Connectivity;
    }

    public void setType(int c) {
        this.m_Connectivity = c;
    }

    public int getWidth() {
        return this.m_Width;
    }

    public void setWidth(int h) {
        this.m_Width = h;
    }

    public static void main(String[] args) {
        MultilabelClassifier.evaluation(new CDT(), args);
    }

    @Override
    public String globalInfo() {
        return "A Conditional Dependency Trellis. Like CDN, but with a trellis structure (like CT) rather than a fully connected network.For more information see:\n" + this.getTechnicalInformation().toString();
    }

    @Override
    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.ARTICLE);
        result.setValue(TechnicalInformation.Field.AUTHOR, "Yuhong Guoand and Suicheng Gu");
        result.setValue(TechnicalInformation.Field.TITLE, "Multi-Label Classification Using Conditional Dependency Networks");
        result.setValue(TechnicalInformation.Field.BOOKTITLE, "IJCAI '11");
        result.setValue(TechnicalInformation.Field.YEAR, "2011");
        result.add(new CT().getTechnicalInformation());
        return result;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract((String)"$Revision: 9117 $");
    }
}

