/*
 * Decompiled with CFR 0.152.
 */
package meka.classifiers.multilabel;

import Jama.Matrix;
import java.util.Random;
import meka.classifiers.multilabel.BPNN;
import meka.classifiers.multilabel.MultilabelClassifier;
import meka.classifiers.multilabel.NN.AbstractDeepNeuralNet;
import meka.core.M;
import meka.core.MLUtils;
import rbms.DBM;
import rbms.RBM;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;

public class DBPNN
extends AbstractDeepNeuralNet
implements TechnicalInformationHandler {
    protected RBM dbm = null;
    protected long rbm_time = 0L;

    @Override
    public void buildClassifier(Instances D) throws Exception {
        this.testCapabilities(D);
        int L = D.classIndex();
        int d = D.numAttributes() - L;
        double[][] X_ = MLUtils.getXfromD(D);
        double[][] Y_ = MLUtils.getYfromD(D);
        if (this.getDebug()) {
            System.out.println("Build RBM(s) ... ");
        }
        this.dbm = new DBM(this.getOptions());
        this.dbm.setE(this.m_E);
        ((DBM)this.dbm).setH(this.m_H, this.m_N);
        long before = System.currentTimeMillis();
        this.dbm.train(X_, this.m_H);
        this.rbm_time = System.currentTimeMillis() - before;
        if (this.getDebug()) {
            Matrix[] tW = this.dbm.getWs();
            System.out.println("X = \n" + M.toString(X_));
            for (int l = 0; l < tW.length; ++l) {
                System.out.println("W = \n" + M.toString(tW[l].getArray()));
            }
            System.out.println("Y = \n" + M.toString(Y_));
        }
        Matrix[] W = DBPNN.trimBiases(this.dbm.getWs());
        if (this.m_Classifier instanceof BPNN) {
            if (this.getDebug()) {
                System.out.println("You have chosen to use BPNN (very good!)");
            }
        } else {
            System.err.println("[Warning] Was expecting BPNN as the base classifier (will set it now, with default parameters) ...");
            this.m_Classifier = new BPNN();
        }
        int i_Y = W.length - 1;
        W[i_Y] = RBM.makeW(W[i_Y].getRowDimension() - 1, W[i_Y].getColumnDimension() - 1, new Random(1L));
        ((BPNN)this.m_Classifier).setWeights(W, L);
        ((BPNN)this.m_Classifier).train(X_, Y_);
        if (this.getDebug()) {
            Matrix[] tW = W;
            System.out.println("W = \n" + M.toString(tW[0].getArray()));
            System.out.println("W = \n" + M.toString(tW[1].getArray()));
            double[][] Ypred = ((BPNN)this.m_Classifier).popY(X_);
            System.out.println("Y = \n" + M.toString(M.threshold(Ypred, 0.5)));
        }
    }

    @Override
    public double[] distributionForInstance(Instance xy) throws Exception {
        return this.m_Classifier.distributionForInstance(xy);
    }

    protected static Matrix trimBiases(Matrix A2) {
        double[][] M_ = A2.getArray();
        return new Matrix(M.removeBias(M_));
    }

    protected static Matrix[] trimBiases(Matrix[] M2) {
        for (int i = 0; i < M2.length; ++i) {
            M2[i] = DBPNN.trimBiases(M2[i]);
        }
        return M2;
    }

    @Override
    public String globalInfo() {
        return "A Deep Back-Propagation Neural Network. For more information see:\n" + this.getTechnicalInformation().toString();
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.ARTICLE);
        result.setValue(TechnicalInformation.Field.AUTHOR, "Geoffrey Hinton and Ruslan Salakhutdinov");
        result.setValue(TechnicalInformation.Field.TITLE, "Reducing the Dimensionality of Data with Neural Networks");
        result.setValue(TechnicalInformation.Field.JOURNAL, "Science");
        result.setValue(TechnicalInformation.Field.VOLUME, "313");
        result.setValue(TechnicalInformation.Field.NUMBER, "5786");
        result.setValue(TechnicalInformation.Field.PAGES, "504-507");
        result.setValue(TechnicalInformation.Field.YEAR, "2006");
        return result;
    }

    public static void main(String[] args) throws Exception {
        MultilabelClassifier.evaluation(new DBPNN(), args);
    }
}

