/*
 * Decompiled with CFR 0.152.
 */
package meka.classifiers.multilabel;

import java.util.Arrays;
import meka.classifiers.multilabel.MultilabelClassifier;
import meka.classifiers.multilabel.RAkELd;
import meka.core.SuperLabelUtils;
import weka.classifiers.AbstractClassifier;
import weka.classifiers.Classifier;
import weka.core.Instances;
import weka.core.RevisionUtils;

public class HASEL
extends RAkELd {
    private static final long serialVersionUID = -6208388889440497988L;

    @Override
    public String globalInfo() {
        return "Partitions labels into subsets based on the dataset defined hierarchy (assuming that a '.' in the attribute names defines hierarchical branches, e.g., \"Europe.Spain\").";
    }

    @Override
    public void buildClassifier(Instances D) throws Exception {
        int L = D.classIndex();
        int N = D.numInstances();
        this.kMap = SuperLabelUtils.getPartitionFromDatasetHierarchy(D);
        this.m_M = this.kMap.length;
        this.m_Classifiers = AbstractClassifier.makeCopies((Classifier)this.m_Classifier, (int)this.m_M);
        this.m_InstancesTemplates = new Instances[this.m_M];
        for (int i = 0; i < this.m_M; ++i) {
            if (this.getDebug()) {
                System.out.println("Building model " + (i + 1) + "/" + this.m_M + ": " + Arrays.toString(this.kMap[i]));
            }
            Instances D_i = SuperLabelUtils.makePartitionDataset(D, this.kMap[i]);
            this.m_Classifiers[i].buildClassifier(D_i);
            this.m_InstancesTemplates[i] = new Instances(D_i, 0);
        }
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract((String)"$Revision: 9117 $");
    }

    public static void main(String[] args) {
        MultilabelClassifier.evaluation(new HASEL(), args);
    }
}

