/*
 * Decompiled with CFR 0.152.
 */
package meka.classifiers.multilabel.NN;

import java.util.Enumeration;
import java.util.Vector;
import meka.classifiers.multilabel.MultilabelClassifier;
import weka.core.Option;
import weka.core.Utils;

public abstract class AbstractNeuralNet
extends MultilabelClassifier {
    protected int m_H = 10;
    protected int m_E = 1000;
    protected double m_R = 0.1;
    protected double m_M = 0.1;

    public void setH(int h) {
        this.m_H = h;
    }

    public int getH() {
        return this.m_H;
    }

    public void setE(int n) {
        this.m_E = n;
    }

    public int getE() {
        return this.m_E;
    }

    @Override
    public String toString() {
        return "h=" + this.getH() + ", E=" + this.getE();
    }

    public Enumeration listOptions() {
        Vector<Object> newVector = new Vector<Object>();
        newVector.addElement(new Option("\tSets the number of hidden units\n\tdefault: " + this.getH() + "\t(off)", "H", 1, "-H <value>"));
        newVector.addElement(new Option("\tSets the maximum number of epochs\n\tdefault: " + this.getE() + "\t(auto-cut-out)", "E", 1, "-E <value>"));
        newVector.addElement(new Option("\tSets the learning rate (set between very small and 0.1)\n\tdefault: " + this.m_R, "r", 1, "-r <value>"));
        newVector.addElement(new Option("\tSets the momentum (set between 0.1 and 0.9)\n\tdefault: " + this.m_M, "m", 1, "-m <value>"));
        Enumeration enu = super.listOptions();
        while (enu.hasMoreElements()) {
            newVector.addElement(enu.nextElement());
        }
        return newVector.elements();
    }

    public void setOptions(String[] options) throws Exception {
        if (Utils.getOptionPos((char)'H', (String[])options) >= 0) {
            this.setH(Integer.parseInt(Utils.getOption((char)'H', (String[])options)));
        }
        if (Utils.getOptionPos((char)'E', (String[])options) >= 0) {
            this.setE(Integer.parseInt(Utils.getOption((char)'E', (String[])options)));
        }
        this.m_R = Utils.getOptionPos((char)'r', (String[])options) >= 0 ? Double.parseDouble(Utils.getOption((char)'r', (String[])options)) : this.m_R;
        this.m_M = Utils.getOptionPos((char)'m', (String[])options) >= 0 ? Double.parseDouble(Utils.getOption((char)'m', (String[])options)) : this.m_M;
        super.setOptions(options);
    }

    public String[] getOptions() {
        String[] superOptions = super.getOptions();
        String[] options = new String[superOptions.length + 8];
        int current = 0;
        options[current++] = "-H";
        options[current++] = String.valueOf(this.getH());
        options[current++] = "-E";
        options[current++] = String.valueOf(this.getE());
        options[current++] = "-r";
        options[current++] = String.valueOf(this.m_R);
        options[current++] = "-m";
        options[current++] = String.valueOf(this.m_M);
        System.arraycopy(superOptions, 0, options, current, superOptions.length);
        return options;
    }
}

