/*
 * Decompiled with CFR 0.152.
 */
package meka.classifiers.multilabel;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Random;
import java.util.Vector;
import meka.classifiers.multilabel.CC;
import meka.classifiers.multilabel.MCC;
import meka.classifiers.multilabel.MultilabelClassifier;
import meka.core.A;
import meka.core.MLUtils;
import weka.classifiers.AbstractClassifier;
import weka.classifiers.Classifier;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.Utils;

public class PMCC
extends MCC {
    protected int m_M = 10;
    protected int m_O = 0;
    protected double m_Beta = 0.03;
    protected CC[] h = null;
    protected double[] w = null;

    public PMCC() {
        super.setChainIterations(50);
    }

    private static int matchedUpto(String s1, String s2, String DELIM) {
        int i;
        String[] s_1 = s1.split(DELIM);
        String[] s_2 = s2.split(DELIM);
        for (i = 0; i < s_1.length && i < s_2.length && s_1[i].equals(s_2[i]); ++i) {
        }
        return i;
    }

    protected static CC getClosest(HashMap<String, CC> map, String sequence) {
        int score = -1;
        String best = sequence;
        for (String key : map.keySet()) {
            int score_ = PMCC.matchedUpto(key, sequence, ",");
            if (score_ <= score) continue;
            score = score_;
            best = key;
        }
        return map.get(best);
    }

    protected CC rebuildCC(CC h_old, int[] s_new, Instances D) throws Exception {
        CC h = (CC)AbstractClassifier.makeCopy((Classifier)h_old);
        h.rebuildClassifier(s_new, new Instances(D));
        return h;
    }

    protected CC buildCC(int[] s, Instances D) throws Exception {
        CC h = new CC();
        h.setChain(s);
        h.setClassifier(this.m_Classifier);
        h.buildClassifier(new Instances(D));
        return h;
    }

    public static int[] pi(int[] s, Random r, int t, double beta) {
        int j;
        int L = s.length;
        System.out.println("--- t = " + t + " , Beta = " + beta + "---");
        double[] p = new double[s.length];
        for (j = 0; j < L; ++j) {
            p[j] = Math.pow(1.0 / (double)L, beta * (double)t / (double)(1 + j));
        }
        Utils.normalize((double[])p);
        j = A.samplePMF(p, r);
        System.out.println("elect j=" + j + " from pmf: " + A.toString(p));
        p[j] = 0.0;
        Utils.normalize((double[])p);
        int k = A.samplePMF(p, r);
        System.out.println("elect k=" + k + " from pmf: " + A.toString(p));
        return A.swap(s, j, k);
    }

    @Override
    public void buildClassifier(Instances D) throws Exception {
        this.m_R = new Random(this.m_S);
        int L = D.classIndex();
        int N = D.numInstances();
        int d = D.numAttributes() - L;
        this.h = new CC[this.m_M];
        this.w = new double[this.m_M];
        if (this.m_Is >= this.m_M) {
            int[] s = MLUtils.gen_indices(L);
            MLUtils.randomize(s, this.m_R);
            this.h[0] = this.buildCC(Arrays.copyOf(s, s.length), D);
            this.w[0] = this.likelihood(this.h[0], D);
            if (this.getDebug()) {
                System.out.println("s[0] = " + Arrays.toString(s));
            }
            for (int t = 0; t < this.m_Is; ++t) {
                int min;
                int[] s_ = this.m_O > 0 ? PMCC.pi(Arrays.copyOf(s, s.length), this.m_R, t, this.m_Beta) : A.swap(Arrays.copyOf(s, s.length), this.m_R);
                CC h_ = this.buildCC(Arrays.copyOf(s_, s_.length), D);
                double w_ = this.likelihood(h_, D);
                if (w_ > this.w[min = Utils.sort((double[])this.w)[0]]) {
                    this.w[min] = w_;
                    this.h[min] = h_;
                    if (this.getDebug()) {
                        System.out.println(" accepted h_ with score " + w_ + " > " + this.w[min]);
                    }
                    s = s_;
                    continue;
                }
                if (!this.getDebug()) continue;
                System.out.println(" DENIED h_ with score " + w_ + " !> score " + this.w[min]);
            }
            if (this.getDebug()) {
                System.out.println("---");
            }
        } else {
            throw new Exception("[Error] Number of chains evaluated (Is) should be at least as great as the population selected (M), and always greater than 0.");
        }
        Utils.normalize((double[])this.w);
    }

    @Override
    public double[] distributionForInstance(Instance x) throws Exception {
        int max = Utils.maxIndex((double[])this.w);
        double[] y = this.h[max].distributionForInstance(x);
        double wm = A.product(this.h[max].probabilityForInstance(x, y));
        for (int t = 0; t < this.m_Iy; ++t) {
            int m = A.samplePMF(this.w, this.m_R);
            double[] y_ = this.h[m].sampleForInstance(x, this.m_R);
            double w_ = A.product(this.h[m].getConfidences());
            if (!(w_ > wm)) continue;
            wm = w_;
            y = y_;
        }
        return y;
    }

    @Override
    public Enumeration listOptions() {
        Vector<Object> newVector = new Vector<Object>();
        newVector.addElement(new Option("\tThe population size (of chains) -- should be smaller than the total number of chains evaluated (Is) \n\tdefault: " + this.m_M, "M", 1, "-M <value>"));
        newVector.addElement(new Option("\tUse temperature: cool the chain down over time (from the beginning of the chain) -- can be faster\n\tdefault: " + this.m_O + " (no temperature)", "O", 1, "-O <value>"));
        newVector.addElement(new Option("\tIf using O = 1 for temperature, this sets the Beta constant      \n\tdefault: " + this.m_Beta, "B", 1, "-B <value>"));
        Enumeration enu = super.listOptions();
        while (enu.hasMoreElements()) {
            newVector.addElement(enu.nextElement());
        }
        return newVector.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        this.m_M = Utils.getOptionPos((char)'M', (String[])options) >= 0 ? Integer.parseInt(Utils.getOption((char)'M', (String[])options)) : this.m_M;
        this.m_O = Utils.getOptionPos((char)'O', (String[])options) >= 0 ? Integer.parseInt(Utils.getOption((char)'O', (String[])options)) : this.m_O;
        this.m_Beta = Utils.getOptionPos((char)'B', (String[])options) >= 0 ? Double.parseDouble(Utils.getOption((char)'B', (String[])options)) : this.m_Beta;
        super.setOptions(options);
    }

    @Override
    public String[] getOptions() {
        ArrayList<String> result = new ArrayList<String>(Arrays.asList(super.getOptions()));
        result.add("-M");
        result.add("" + this.m_M);
        result.add("-O");
        result.add("" + this.m_O);
        result.add("-B");
        result.add("" + this.m_Beta);
        return result.toArray(new String[result.size()]);
    }

    public void setM(int M2) {
        this.m_M = M2;
    }

    public int getM() {
        return this.m_M;
    }

    @Override
    public String globalInfo() {
        return "PMCC - Like MCC but selects the top M chains at training time, and uses all them at test time (using Monte Carlo sampling -- this is not a typical majority-vote ensemble method). For more information see:\n" + this.getTechnicalInformation().toString();
    }

    public static void main(String[] args) {
        MultilabelClassifier.evaluation(new PMCC(), args);
    }
}

