/*
 * Decompiled with CFR 0.152.
 */
package meka.classifiers.multilabel.incremental;

import meka.classifiers.multilabel.BR;
import meka.classifiers.multilabel.incremental.IncrementalEvaluation;
import meka.core.MLUtils;
import weka.classifiers.UpdateableClassifier;
import weka.classifiers.trees.HoeffdingTree;
import weka.core.Instance;

public class BRUpdateable
extends BR
implements UpdateableClassifier {
    private static final long serialVersionUID = 6705611077773512052L;

    @Override
    public String globalInfo() {
        return "Updateable BR\nMust be run with an Updateable base classifier.";
    }

    public BRUpdateable() {
        this.m_Classifier = new HoeffdingTree();
    }

    @Override
    protected String defaultClassifierString() {
        return "weka.classifiers.trees.HoeffdingTree";
    }

    public void updateClassifier(Instance x) throws Exception {
        int L = x.classIndex();
        if (this.getDebug()) {
            System.out.print("-: Updating " + L + " models");
        }
        for (int j = 0; j < L; ++j) {
            Instance x_j = (Instance)x.copy();
            x_j.setDataset(null);
            x_j = MLUtils.keepAttributesAt(x_j, new int[]{j}, L);
            x_j.setDataset(this.m_InstancesTemplates[j]);
            ((UpdateableClassifier)this.m_MultiClassifiers[j]).updateClassifier(x_j);
        }
        if (this.getDebug()) {
            System.out.println(":- ");
        }
    }

    public static void main(String[] args) {
        IncrementalEvaluation.runExperiment(new BRUpdateable(), args);
    }
}

