/*
 * Decompiled with CFR 0.152.
 */
package meka.classifiers.multilabel.incremental;

import java.io.IOException;
import java.util.Arrays;
import java.util.Enumeration;
import meka.classifiers.multilabel.Evaluation;
import meka.classifiers.multilabel.MultilabelClassifier;
import meka.core.MLEvalUtils;
import meka.core.MLUtils;
import meka.core.Result;
import meka.core.ThresholdUtils;
import weka.classifiers.UpdateableClassifier;
import weka.core.AbstractInstance;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.Utils;

public class IncrementalEvaluation {
    private static String[] measures = new String[]{"Accuracy", "Exact match", "Hamming score", "Build_time", "Total_time"};

    public static void runExperiment(MultilabelClassifier h, String[] args) {
        try {
            h.setOptions(args);
            Result avg = IncrementalEvaluation.evaluateModel(h, args);
            System.out.println(avg);
        }
        catch (Exception e) {
            System.err.println("Evaluation exception (" + e + "); failed to run experiment");
            e.printStackTrace();
            IncrementalEvaluation.printOptions(h.listOptions());
        }
    }

    public static Result evaluateModel(MultilabelClassifier h, String[] options) throws Exception {
        String Vop;
        Instances D = Evaluation.loadDataset(options);
        MLUtils.prepareData(D);
        int nWin = 20;
        try {
            nWin = Utils.getOptionPos((char)'B', (String[])options) >= 0 ? Integer.parseInt(Utils.getOption((char)'B', (String[])options)) : nWin;
        }
        catch (Exception e) {
            throw new Exception("[Error] Failed to parse option B");
        }
        double rLabeled = 1.0;
        try {
            rLabeled = Utils.getOptionPos((String)"semisupervised", (String[])options) >= 0 ? Double.parseDouble(Utils.getOption((String)"semisupervised", (String[])options)) : rLabeled;
        }
        catch (IOException e) {
            throw new Exception("[Error] Failed to parse option S");
        }
        String Top = Utils.getOptionPos((String)"threshold", (String[])options) >= 0 ? Utils.getOption((String)"threshold", (String[])options) : "PCut1";
        String string = Vop = Utils.getOptionPos((String)"verbosity", (String[])options) >= 0 ? Utils.getOption((String)"verbosity", (String[])options) : "3";
        if (h.getDebug()) {
            System.out.println(":- Dataset -: " + MLUtils.getDatasetName(D) + "\tL=" + D.classIndex() + "");
        }
        Utils.checkForRemainingOptions((String[])options);
        Result[] results = IncrementalEvaluation.evaluateModel(h, D, nWin, rLabeled, Top, Vop);
        return results[results.length - 1];
    }

    public static Result[] evaluateModel(MultilabelClassifier h, Instances D) throws Exception {
        return IncrementalEvaluation.evaluateModel(h, D, 20, 1.0, "PCut1", "3");
    }

    public static Result[] evaluateModel(MultilabelClassifier h, Instances D, int numWindows, double rLabeled, String Top, String Vop) throws Exception {
        if (h.getDebug()) {
            System.out.println(":- Classifier -: " + ((Object)((Object)h)).getClass().getName() + ": " + Arrays.toString(h.getOptions()));
        }
        int N = D.numInstances();
        int L = D.classIndex();
        Result[] results = new Result[numWindows - 1];
        long train_time = 0L;
        long test_time = 0L;
        int windowSize = (int)Math.floor((double)D.numInstances() / (double)numWindows);
        if (rLabeled * (double)windowSize < 1.0) {
            throw new Exception("[Error] The ratio of labelled instances (" + rLabeled + ") is too small given the window size!");
        }
        double nth = 1.0 / rLabeled;
        Instances D_init = new Instances(D, 0, windowSize);
        if (h.getDebug()) {
            System.out.println("Training classifier on initial window ...");
        }
        train_time = System.currentTimeMillis();
        h.buildClassifier(D_init);
        train_time = System.currentTimeMillis() - train_time;
        if (h.getDebug()) {
            System.out.println("Done (in " + (double)train_time / 1000.0 + " s)");
        }
        D = new Instances(D, windowSize, D.numInstances() - windowSize);
        double[] t = new double[L];
        Arrays.fill(t, 0.5);
        int V = MLUtils.getIntegerOption(Vop, 3);
        if (V > 3) {
            System.out.println("--------------------------------------------------------------------------------");
            System.out.print("#" + Utils.padLeft((String)"w", (int)6) + " " + Utils.padLeft((String)"n", (int)6));
            for (String m : measures) {
                System.out.print(" ");
                System.out.print(Utils.padLeft((String)m, (int)12));
            }
            System.out.println("");
            System.out.println("--------------------------------------------------------------------------------");
        }
        int i = 0;
        for (int w = 0; w < numWindows - 1; ++w) {
            results[w] = new Result(L);
            results[w].setInfo("Supervision", String.valueOf(rLabeled));
            int n = 0;
            test_time = 0L;
            train_time = 0L;
            boolean c = false;
            while (i < w * windowSize + windowSize) {
                Instance x = D.instance(i);
                AbstractInstance x_ = (AbstractInstance)((AbstractInstance)x).copy();
                if (rLabeled < 0.5 && i % (int)(1.0 / rLabeled) == 0 || rLabeled >= 0.5 && i % (int)(1.0 / (1.0 - rLabeled)) != 0) {
                    long before_test = System.currentTimeMillis();
                    double[] y = h.distributionForInstance((Instance)x_);
                    long after_test = System.currentTimeMillis();
                    test_time += after_test - before_test;
                    results[w].addResult(y, x);
                    ++n;
                } else {
                    x = MLUtils.setLabelsMissing(x, L);
                }
                long before = System.currentTimeMillis();
                ((UpdateableClassifier)h).updateClassifier(x);
                long after = System.currentTimeMillis();
                train_time += after - before;
                ++i;
            }
            results[w].setInfo("Type", "ML");
            results[w].setInfo("Threshold", Arrays.toString(t));
            results[w].output = Result.getStats(results[w], Vop);
            results[w].output.put("Test_time", (double)test_time / 1000.0);
            results[w].output.put("Build_time", (double)train_time / 1000.0);
            results[w].output.put("Total_time", (double)(test_time + train_time) / 1000.0);
            if (V > 3) {
                System.out.print("#" + Utils.doubleToString((double)((double)w + 1.0), (int)6, (int)0) + " " + Utils.doubleToString((double)n, (int)6, (int)0));
                n = 0;
                for (String m : measures) {
                    System.out.print(" ");
                    System.out.print(Utils.doubleToString((double)results[w].output.get(m), (int)12, (int)4));
                }
                System.out.println("");
            }
            if (Top.equals("PCutL")) {
                t = ThresholdUtils.calibrateThresholds(results[w].predictions, MLUtils.labelCardinalities(results[w].actuals));
                continue;
            }
            Arrays.fill(t, ThresholdUtils.calibrateThreshold(results[w].predictions, MLUtils.labelCardinality(results[w].allActuals())));
        }
        if (V > 3) {
            System.out.println("--------------------------------------------------------------------------------");
        }
        Result avg = MLEvalUtils.averageResults(results);
        avg.setInfo("Classifier_name", ((Object)((Object)h)).getClass().getName());
        avg.setInfo("Classifier_ops", Arrays.toString(h.getOptions()));
        avg.setInfo("Classifier_info", h.toString());
        avg.setInfo("Dataset_name", MLUtils.getDatasetName(D));
        return new Result[]{avg};
    }

    public static void printOptions(Enumeration e) {
        StringBuffer text = new StringBuffer();
        text.append("\n\nEvaluation Options:\n\n");
        text.append("-t\n");
        text.append("\tSpecify the dataset (required)\n");
        text.append("-B <number of windows>\n");
        text.append("\tSets the number of windows (batches) for evalutation; default: 20.\n");
        text.append("-semisupervised <ratio labelled>\n");
        text.append("\tSets the ratio of labelled instances; default: 1.0.\n");
        text.append("-threshold <threshold>\n");
        text.append("\tSets the type of thresholding; where 'PCut1' automatically calibrates a threshold (the default); 'PCutL' automatically calibrates one threshold for each label; and any double number, e.g. '0.5', specifies that threshold.\n");
        text.append("-verbosity <verbosity level>\n");
        text.append("\tSpecify more/less evaluation.\n");
        text.append("\n\nClassifier Options:\n\n");
        while (e.hasMoreElements()) {
            Option o = (Option)e.nextElement();
            text.append("-" + o.name() + '\n');
            text.append("" + o.description() + '\n');
        }
        System.out.println(text);
    }
}

