/*
 * Decompiled with CFR 0.152.
 */
package meka.classifiers.multilabel.incremental;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;
import meka.classifiers.multilabel.PS;
import meka.classifiers.multilabel.incremental.IncrementalEvaluation;
import meka.classifiers.multilabel.incremental.MajorityLabelsetUpdateable;
import meka.core.LabelSet;
import meka.core.MLUtils;
import meka.core.PSUtils;
import weka.classifiers.UpdateableClassifier;
import weka.classifiers.trees.HoeffdingTree;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.Utils;

public class PSUpdateable
extends PS
implements UpdateableClassifier {
    private static final long serialVersionUID = -3909203248118831224L;
    protected int m_Counter = 0;
    protected int m_Limit = 1000;
    protected int m_Support = 10;
    protected int L = -1;
    protected HashMap<LabelSet, Integer> combinations = null;
    protected Instances batch = null;
    protected Instance m_InstanceTemplate = null;
    protected MajorityLabelsetUpdateable mlu = new MajorityLabelsetUpdateable();

    @Override
    public String globalInfo() {
        return "Updateable PS";
    }

    public PSUpdateable() {
        this.m_Classifier = new HoeffdingTree();
    }

    @Override
    protected String defaultClassifierString() {
        return "weka.classifiers.trees.HoeffdingTree";
    }

    @Override
    public void buildClassifier(Instances D) throws Exception {
        this.testCapabilities(D);
        this.L = D.classIndex();
        this.m_Counter = D.numInstances();
        if (this.m_Counter > this.m_Limit) {
            if (this.getDebug()) {
                System.out.println("init build @ " + D.numInstances());
            }
            this.combinations = PSUtils.countCombinationsSparse(D, this.L);
            MLUtils.pruneCountHashMap(this.combinations, this.m_P);
            int p = this.m_P;
            while (this.combinations.size() > this.m_Support) {
                ++this.m_P;
                MLUtils.pruneCountHashMap(this.combinations, this.m_P);
            }
            super.buildClassifier(D);
            this.m_P = p;
        } else {
            if (this.getDebug()) {
                System.out.println("start batch @ " + D.numInstances());
            }
            this.batch = new Instances(D);
            this.mlu.buildClassifier(D);
        }
    }

    public void updateClassifier(Instance x) throws Exception {
        if (this.m_Counter < this.m_Limit) {
            this.batch.add(x);
            this.mlu.updateClassifier(x);
            if (++this.m_Counter >= this.m_Limit) {
                this.combinations = PSUtils.countCombinationsSparse(this.batch, this.L);
                MLUtils.pruneCountHashMap(this.combinations, this.m_P);
                int p = this.m_P;
                while (this.combinations.size() > this.m_Support) {
                    ++this.m_P;
                    MLUtils.pruneCountHashMap(this.combinations, this.m_P);
                }
                super.buildClassifier(this.batch);
                this.m_P = p;
                this.batch.clear();
                this.mlu = null;
            }
        } else {
            for (Instance x_i : PSUtils.PSTransformation(x, this.L, this.combinations, this.m_N)) {
                ((UpdateableClassifier)this.m_Classifier).updateClassifier(x_i);
            }
        }
    }

    @Override
    public double[] distributionForInstance(Instance x) throws Exception {
        int L = x.classIndex();
        if (this.m_Counter < this.m_Limit) {
            return this.mlu.distributionForInstance(x);
        }
        return super.distributionForInstance(x);
    }

    @Override
    public String[] getOptions() {
        String[] superOptions = super.getOptions();
        String[] options = new String[superOptions.length + 4];
        int current = 0;
        options[current++] = "-I";
        options[current++] = "" + this.m_Limit;
        options[current++] = "-S";
        options[current++] = "" + this.m_Support;
        System.arraycopy(superOptions, 0, options, current, superOptions.length);
        return options;
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        block5: {
            block4: {
                try {
                    this.m_Limit = Integer.parseInt(Utils.getOption((char)'I', (String[])options));
                }
                catch (Exception e) {
                    if (!this.getDebug()) break block4;
                    System.err.println("Using default m_Limit = " + this.m_Limit);
                }
            }
            try {
                this.m_Support = Integer.parseInt(Utils.getOption((char)'S', (String[])options));
            }
            catch (Exception e) {
                if (!this.getDebug()) break block5;
                System.err.println("Using default m_Support = " + this.m_Support);
            }
        }
        super.setOptions(options);
    }

    @Override
    public Enumeration listOptions() {
        Vector<Object> newVector = new Vector<Object>();
        newVector.addElement(new Option("\tSets the buffer size        \n\tdefault: " + this.m_Limit + "", "I", 1, "-I <value>"));
        newVector.addElement(new Option("\tSets the max. num. of combs.\n\tdefault: " + this.m_Support + "", "S", 1, "-S <value>"));
        Enumeration enu = super.listOptions();
        while (enu.hasMoreElements()) {
            newVector.addElement(enu.nextElement());
        }
        return newVector.elements();
    }

    public static void main(String[] args) {
        IncrementalEvaluation.runExperiment(new PSUpdateable(), args);
    }
}

