/*
 * Decompiled with CFR 0.152.
 */
package meka.classifiers.multilabel.incremental.meta;

import java.util.Random;
import meka.classifiers.multilabel.incremental.BRUpdateable;
import meka.classifiers.multilabel.incremental.IncrementalEvaluation;
import meka.classifiers.multilabel.meta.EnsembleML;
import weka.classifiers.UpdateableClassifier;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;

public class BaggingMLUpdateable
extends EnsembleML
implements UpdateableClassifier,
TechnicalInformationHandler {
    protected Random random = null;

    @Override
    public String globalInfo() {
        return "Incremental Bagging";
    }

    public BaggingMLUpdateable() {
        this.m_Classifier = new BRUpdateable();
    }

    @Override
    protected String defaultClassifierString() {
        return "meka.classifiers.multilabel.incremental.BRUpdateable";
    }

    @Override
    public void buildClassifier(Instances D) throws Exception {
        this.random = new Random(this.m_Seed);
        super.buildClassifier(D);
    }

    public void updateClassifier(Instance x) throws Exception {
        for (int i = 0; i < this.m_NumIterations; ++i) {
            int k = BaggingMLUpdateable.poisson(1.0, this.random);
            if (this.m_BagSizePercent == 100) {
                k = 1;
            }
            if (k <= 0) continue;
            Instance x_weighted = (Instance)x.copy();
            x_weighted.setWeight(x.weight() * (double)k);
            ((UpdateableClassifier)this.m_Classifiers[i]).updateClassifier(x_weighted);
        }
    }

    protected static int poisson(double lambda, Random r) {
        if (lambda < 100.0) {
            int i;
            double product = 1.0;
            double sum = 1.0;
            double threshold = r.nextDouble() * Math.exp(lambda);
            int max = Math.max(100, 10 * (int)Math.ceil(lambda));
            for (i = 1; i < max && sum <= threshold; sum += (product *= lambda / (double)i), ++i) {
            }
            return i - 1;
        }
        double x = lambda + Math.sqrt(lambda) * r.nextGaussian();
        if (x < 0.0) {
            return 0;
        }
        return (int)Math.floor(x);
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.ARTICLE);
        result.setValue(TechnicalInformation.Field.AUTHOR, "N.Oza, S. Russell");
        result.setValue(TechnicalInformation.Field.TITLE, "Online bagging and boosting");
        result.setValue(TechnicalInformation.Field.JOURNAL, "Artificial Intelligence and Statistics");
        result.setValue(TechnicalInformation.Field.PUBLISHER, "Morgan Kaufmann");
        result.setValue(TechnicalInformation.Field.YEAR, "2001");
        result.setValue(TechnicalInformation.Field.PAGES, "105-112");
        return result;
    }

    public static void main(String[] args) {
        IncrementalEvaluation.runExperiment(new BaggingMLUpdateable(), args);
    }
}

