/*
 * Decompiled with CFR 0.152.
 */
package meka.classifiers.multilabel.incremental.meta;

import meka.classifiers.multilabel.MultilabelClassifier;
import meka.classifiers.multilabel.incremental.IncrementalEvaluation;
import meka.classifiers.multilabel.incremental.meta.BaggingMLUpdateable;
import meka.core.MLUtils;
import moa.classifiers.core.driftdetection.ADWIN;
import weka.classifiers.AbstractClassifier;
import weka.classifiers.Classifier;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Utils;

public class BaggingMLUpdateableADWIN
extends BaggingMLUpdateable {
    protected ADWIN adwin = null;
    protected double[] accuracies;

    @Override
    public void buildClassifier(Instances D) throws Exception {
        this.adwin = new ADWIN();
        this.accuracies = new double[this.m_NumIterations];
        this.m_InstancesTemplate = new Instances(D, 0);
        super.buildClassifier(D);
    }

    @Override
    public double[] distributionForInstance(Instance x) throws Exception {
        double[] y = new double[x.classIndex()];
        int i = 0;
        while (i < this.m_NumIterations) {
            double[] y_i = this.m_Classifiers[i].distributionForInstance(x);
            for (int j = 0; j < y_i.length; ++j) {
                int n = j;
                y[n] = y[n] + y_i[j];
            }
            int n = i++;
            this.accuracies[n] = this.accuracies[n] + this.error(y_i, MLUtils.toDoubleArray(x, y.length));
        }
        for (int j = 0; j < y.length; ++j) {
            y[j] = y[j] / (double)this.m_NumIterations;
        }
        double d = this.error(y, MLUtils.toDoubleArray(x, y.length));
        double ErrEstim = this.adwin.getEstimation();
        if (this.adwin.setInput(1.0 - d) && this.adwin.getEstimation() > ErrEstim) {
            int index = Utils.minIndex((double[])this.accuracies);
            if (this.getDebug()) {
                System.out.println("------- CHANGE DETECTED / Reset Model #" + index + " ------- ");
            }
            this.m_Classifiers[index] = (MultilabelClassifier)AbstractClassifier.makeCopy((Classifier)this.m_Classifier);
            this.m_Classifiers[index].buildClassifier(new Instances(this.m_InstancesTemplate));
            this.adwin = new ADWIN();
            this.accuracies = new double[this.m_NumIterations];
        }
        return y;
    }

    private double error(double[] y_pred, double[] y_real) {
        double distance = 0.0;
        for (int j = 0; j < y_pred.length; ++j) {
            distance += Math.pow(y_pred[j] - y_real[j], 2.0);
        }
        return distance;
    }

    public static void main(String[] args) {
        IncrementalEvaluation.runExperiment(new BaggingMLUpdateableADWIN(), args);
    }
}

