/*
 * Decompiled with CFR 0.152.
 */
package meka.classifiers.multilabel.meta;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Vector;
import meka.classifiers.multilabel.CC;
import meka.classifiers.multilabel.MultilabelClassifier;
import meka.classifiers.multilabel.SemisupervisedClassifier;
import meka.core.MLUtils;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.RevisionUtils;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;

public class EM
extends MultilabelClassifier
implements SemisupervisedClassifier,
TechnicalInformationHandler {
    protected int m_I = 10;
    protected Instances D_ = null;

    public EM() {
        this.m_Classifier = new CC();
    }

    @Override
    protected String defaultClassifierString() {
        return "meka.classifiers.multilabel.CC";
    }

    @Override
    public void setUnlabelledData(Instances D) {
        this.D_ = D;
    }

    @Override
    public String globalInfo() {
        return "A specified multi-label classifier is built on the training data. This model is then used to classify the test data. The confidence with which instances are classified is used to reweight them. This data is then used to retrain the classifier. This cycle continues ('EM'-style) for I iterations. The final model is used to officially classifier the test data. Because of the weighting, it is advised to use a classifier which gives good confidence (probabalistic) outputs. ";
    }

    @Override
    public void buildClassifier(Instances D) throws Exception {
        this.testCapabilities(D);
        if (this.getDebug()) {
            System.out.println("Initial build ...");
        }
        this.m_Classifier.buildClassifier(D);
        Instances DA = MLUtils.combineInstances(D, this.D_);
        if (this.getDebug()) {
            System.out.print("Performing " + this.m_I + " 'EM' Iterations: [");
        }
        for (int i = 0; i < this.m_I; ++i) {
            if (this.getDebug()) {
                System.out.print(".");
            }
            this.updateWeights((MultilabelClassifier)this.m_Classifier, DA);
            this.m_Classifier.buildClassifier(DA);
        }
        System.out.println("]");
    }

    protected void updateWeights(MultilabelClassifier h, Instances D) throws Exception {
        for (Instance x : D) {
            double w = 1.0;
            double[] y = h.distributionForInstance(x);
            for (int j = 0; j < y.length; ++j) {
                w *= y[j] < 0.5 ? 1.0 - y[j] : y[j];
            }
            x.setWeight(w);
        }
    }

    @Override
    public double[] distributionForInstance(Instance x) throws Exception {
        return this.m_Classifier.distributionForInstance(x);
    }

    public void setIterations(int i) {
        this.m_I = i;
    }

    public int getIterations() {
        return this.m_I;
    }

    public Enumeration listOptions() {
        Vector<Object> newVector = new Vector<Object>();
        newVector.addElement(new Option("\tThe number of iterations of EM to carry out (default: " + this.m_I + ")", "I", 1, "-I <value>"));
        Enumeration enu = super.listOptions();
        while (enu.hasMoreElements()) {
            newVector.addElement(enu.nextElement());
        }
        return newVector.elements();
    }

    public void setOptions(String[] options) throws Exception {
        this.m_I = Utils.getOptionPos((char)'I', (String[])options) >= 0 ? Integer.parseInt(Utils.getOption((char)'I', (String[])options)) : this.m_I;
        super.setOptions(options);
    }

    public String[] getOptions() {
        ArrayList<String> result = new ArrayList<String>(Arrays.asList(super.getOptions()));
        result.add("-I");
        result.add(String.valueOf(this.m_I));
        return result.toArray(new String[result.size()]);
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract((String)"$Revision: 9117 $");
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.ARTICLE);
        result.setValue(TechnicalInformation.Field.AUTHOR, "Nigam, Kamal and Mccallum, Andrew K. and Thrun, Sebastian and Mitchell, Tom M.");
        result.setValue(TechnicalInformation.Field.TITLE, "Text classification from Labeled and Unlabeled Documents using EM");
        result.setValue(TechnicalInformation.Field.JOURNAL, "Machine Learning");
        result.setValue(TechnicalInformation.Field.VOLUME, "39");
        result.setValue(TechnicalInformation.Field.NUMBER, "2/3");
        result.setValue(TechnicalInformation.Field.PAGES, "103--134");
        result.setValue(TechnicalInformation.Field.YEAR, "2010");
        return result;
    }

    public static void main(String[] args) {
        MultilabelClassifier.evaluation(new EM(), args);
    }
}

