/*
 * Decompiled with CFR 0.152.
 */
package meka.core;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import meka.core.A;

public class LabelSet
implements Comparator,
Serializable {
    private static final long serialVersionUID = -6089833712444497991L;
    public int[] indices;

    public LabelSet() {
    }

    public LabelSet(int[] indices) {
        this.indices = indices;
    }

    public LabelSet(int[] indices, boolean sort) {
        this.indices = indices;
        if (sort) {
            Arrays.sort(this.indices);
        }
    }

    public LabelSet(List<Integer> list) {
        Integer[] array = list.toArray(new Integer[0]);
        this.indices = A.toPrimitive(array);
    }

    public LabelSet(Set<Integer> set) {
        Integer[] array = set.toArray(new Integer[0]);
        this.indices = A.toPrimitive(array);
    }

    public final boolean contains(int j) {
        return Arrays.binarySearch(this.indices, j) >= 0;
    }

    public final boolean contains(int[] js) {
        for (int j : js) {
            if (this.contains(j)) continue;
            return false;
        }
        return true;
    }

    public final int hashCode() {
        return Arrays.hashCode(this.indices);
    }

    @Override
    public boolean equals(Object o) {
        LabelSet l2 = (LabelSet)o;
        if (this.indices.length != l2.indices.length) {
            return false;
        }
        for (int i = 0; i < this.indices.length; ++i) {
            if (this.indices[i] == l2.indices[i]) continue;
            return false;
        }
        return true;
    }

    public int compare(Object o1, Object o2) {
        LabelSet l1 = (LabelSet)o1;
        LabelSet l2 = (LabelSet)o2;
        if (l2.indices.length > l1.indices.length) {
            return -1;
        }
        if (l2.indices.length < l1.indices.length) {
            return 1;
        }
        return 0;
    }

    public final int subsetof(LabelSet y) {
        return LabelSet.subset(this.indices, y.indices);
    }

    public static final int subset(int[] y1, int[] y2) {
        int j = 0;
        int k = 0;
        while (j < y1.length) {
            if (k >= y2.length) {
                return -1;
            }
            if (y1[j] == y2[k]) {
                ++j;
                ++k;
                continue;
            }
            if (y1[j] > y2[k]) {
                ++k;
                continue;
            }
            return -1;
        }
        return j;
    }

    public void minus(LabelSet l2) {
        this.indices = LabelSet.minus(this.indices, l2.indices);
    }

    public static int[] minus(int[] y1, int[] y2) {
        int[] keep = new int[Math.max(y1.length, y2.length)];
        int i = 0;
        int j = 0;
        int k = 0;
        while (j < y1.length && k < y2.length) {
            if (y1[j] == y2[k]) {
                ++j;
                ++k;
                continue;
            }
            if (y1[j] < y2[k]) {
                keep[i++] = y1[j];
                ++j;
                continue;
            }
            ++k;
        }
        while (j < y1.length) {
            keep[i++] = y1[j++];
        }
        return Arrays.copyOf(keep, i);
    }

    public int distance(LabelSet o) {
        return 0;
    }

    public LabelSet deep_copy() {
        return new LabelSet(Arrays.copyOf(this.indices, this.indices.length));
    }

    public String toString() {
        return Arrays.toString(this.indices);
    }
}

