/*
 * Decompiled with CFR 0.152.
 */
package meka.core;

import Jama.Matrix;
import java.util.Arrays;

public abstract class M {
    public static double[] getCol(double[][] M2, int k) {
        double[] col_k = new double[M2.length];
        for (int i = 0; i < M2.length; ++i) {
            col_k[i] = M2[i][k];
        }
        return col_k;
    }

    public static int[] getCol(int[][] M2, int k) {
        int[] col_k = new int[M2.length];
        for (int i = 0; i < M2.length; ++i) {
            col_k[i] = M2[i][k];
        }
        return col_k;
    }

    public static double[][] addBias(double[][] M2) {
        double[][] C = new double[M2.length][M2[0].length + 1];
        for (int i = 0; i < M2.length; ++i) {
            C[i][0] = 1.0;
            for (int j = 0; j < M2[i].length; ++j) {
                C[i][j + 1] = M2[i][j];
            }
        }
        return C;
    }

    public static Matrix addBias(Matrix M2) {
        double[][] M_ = M2.getArray();
        double[][] C = new double[M_.length][M_[0].length + 1];
        for (int i = 0; i < M_.length; ++i) {
            C[i][0] = 1.0;
            for (int j = 0; j < M_[i].length; ++j) {
                C[i][j + 1] = M_[i][j];
            }
        }
        return new Matrix(C);
    }

    public static double[][] removeBias(double[][] M2) {
        double[][] C = new double[M2.length][M2[0].length - 1];
        for (int i = 0; i < M2.length; ++i) {
            for (int j = 1; j < M2[i].length; ++j) {
                C[i][j - 1] = M2[i][j];
            }
        }
        return C;
    }

    public static double[][] multiply(double[][] A2, double K) {
        double[][] C = new double[A2.length][A2[0].length];
        for (int i = 0; i < A2.length; ++i) {
            for (int j = 0; j < A2[i].length; ++j) {
                C[i][j] = A2[i][j] * K;
            }
        }
        return C;
    }

    public static String toString(double[][] M_, int adp) {
        int width = adp > 0 ? adp + 2 : 0;
        StringBuilder sb = new StringBuilder();
        for (int j = 0; j < M_.length; ++j) {
            for (int k = 0; k < M_[j].length; ++k) {
                double d = M_[j][k];
                String num = String.format("%6.2f", d);
                if (adp == 0) {
                    num = String.format("%2.0f", d);
                }
                sb.append(num);
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    public static String toString(double[][] M_) {
        return M.toString(M_, 2);
    }

    public static String toString(int[][] M_) {
        StringBuilder sb = new StringBuilder();
        for (int j = 0; j < M_.length; ++j) {
            for (int k = 0; k < M_[j].length; ++k) {
                String num = String.format("%5d", M_[j][k]);
                sb.append(num);
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    public static String toString(double[][] M2, String name) {
        StringBuilder sb = new StringBuilder(name + " = [\n");
        for (int j = 0; j < M2.length; ++j) {
            for (int k = 0; k < M2[j].length; ++k) {
                sb.append(String.format("%6.2f ", M2[j][k]));
            }
            sb.append(";\n");
        }
        sb.append("]");
        return sb.toString();
    }

    public static final double[][] threshold(double[][] P, double t) {
        double[][] X = new double[P.length][P[0].length];
        for (int i = 0; i < P.length; ++i) {
            for (int j = 0; j < P[i].length; ++j) {
                X[i][j] = P[i][j] > t ? 1.0 : 0.0;
            }
        }
        return X;
    }

    public static int[] flatten(int[][] M2) {
        int[] v = new int[M2.length * M2[0].length];
        int k = 0;
        for (int i = 0; i < M2.length; ++i) {
            for (int j = 0; j < M2[i].length; ++j) {
                v[k++] = M2[i][j];
            }
        }
        return v;
    }

    public static double[][] subtract(double[][] A2, double[][] B) {
        double[][] C = new double[A2.length][A2[0].length];
        for (int i = 0; i < A2.length; ++i) {
            for (int j = 0; j < A2[i].length; ++j) {
                C[i][j] = A2[i][j] - B[i][j];
            }
        }
        return C;
    }

    public static double[][] abs(double[][] A2) {
        double[][] C = new double[A2.length][A2[0].length];
        for (int i = 0; i < A2.length; ++i) {
            for (int j = 0; j < A2[i].length; ++j) {
                C[i][j] = Math.abs(A2[i][j]);
            }
        }
        return C;
    }

    public static double SS(double[][] M2) {
        double sum = 0.0;
        for (int i = 0; i < M2.length; ++i) {
            for (int j = 0; j < M2[i].length; ++j) {
                sum += M2[i][j];
            }
        }
        return sum;
    }

    public static final double sigma(double a) {
        return 1.0 / (1.0 + Math.exp(-a));
    }

    public static final double[] sigma(double[] v) {
        double[] u = new double[v.length];
        for (int j = 0; j < v.length; ++j) {
            u[j] = M.sigma(v[j]);
        }
        return u;
    }

    public static final double[][] sigma(double[][] A2) {
        double[][] X = new double[A2.length][A2[0].length];
        for (int i = 0; i < A2.length; ++i) {
            for (int j = 0; j < A2[i].length; ++j) {
                X[i][j] = M.sigma(A2[i][j]);
            }
        }
        return X;
    }

    public static final Matrix sigma(Matrix A2) {
        return new Matrix(M.sigma(A2.getArray()));
    }

    public static final double dsigma(double a) {
        double s = M.sigma(a);
        return s * (1.0 - s);
    }

    public static final double[] dsigma(double[] v) {
        double[] u = new double[v.length];
        for (int j = 0; j < v.length; ++j) {
            u[j] = M.dsigma(v[j]);
        }
        return u;
    }

    public static final double[][] dsigma(double[][] A2) {
        double[][] X = new double[A2.length][A2[0].length];
        for (int i = 0; i < A2.length; ++i) {
            for (int j = 0; j < A2[i].length; ++j) {
                X[i][j] = M.dsigma(A2[i][j]);
            }
        }
        return X;
    }

    public static final Matrix dsigma(Matrix A2) {
        double[][] A_ = A2.getArray();
        double[][] X = new double[A_.length][A_[0].length];
        for (int i = 0; i < A_.length; ++i) {
            for (int j = 0; j < A_[i].length; ++j) {
                X[i][j] = M.dsigma(A_[i][j]);
            }
        }
        return new Matrix(X);
    }

    public static int[][] deep_copy(int[][] M2) {
        int[][] C = new int[M2.length][];
        for (int i = 0; i < C.length; ++i) {
            C[i] = Arrays.copyOf(M2[i], M2[i].length);
        }
        return C;
    }
}

