/*
 * Decompiled with CFR 0.152.
 */
package meka.core;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import meka.core.A;
import meka.core.LabelSet;
import meka.core.MLEvalUtils;
import meka.core.MLUtils;
import meka.core.ThresholdUtils;
import weka.core.Instance;
import weka.core.Utils;

public class Result
implements Serializable {
    private static final long serialVersionUID = 1L;
    public int L = 0;
    public ArrayList<double[]> predictions = null;
    public ArrayList<int[]> actuals = null;
    public HashMap<String, Double> output = new LinkedHashMap<String, Double>();
    public HashMap<String, String> info = new LinkedHashMap<String, String>();
    public HashMap<String, Double> vals = new LinkedHashMap<String, Double>();

    public Result() {
        this.predictions = new ArrayList();
        this.actuals = new ArrayList();
    }

    public Result(int L) {
        this.predictions = new ArrayList();
        this.actuals = new ArrayList();
        this.L = L;
    }

    public Result(int N, int L) {
        this.predictions = new ArrayList(N);
        this.actuals = new ArrayList(N);
        this.L = L;
    }

    public int size() {
        return this.predictions.size();
    }

    public String toString() {
        int V;
        String resultString = "";
        if (this.info.containsKey("Verbosity") && (V = MLUtils.getIntegerOption(this.info.get("Verbosity"), 1)) > 4) {
            resultString = Result.getResultAsString(this, V - 5);
        }
        return resultString + MLUtils.hashMapToString(this.info) + "\n" + MLUtils.hashMapToString(this.output, 3) + "\n" + MLUtils.hashMapToString(this.vals, 3);
    }

    public void addResult(double[] pred, Instance real) {
        this.predictions.add(pred);
        this.actuals.add(MLUtils.toIntArray(real, pred.length));
    }

    public int[] rowActual(int i) {
        return this.actuals.get(i);
    }

    public double[] rowRanking(int i) {
        return this.predictions.get(i);
    }

    public int[] rowPrediction(int i, double t) {
        return MLUtils.toIntArray(this.rowRanking(i), t);
    }

    public int[] rowPrediction(int i) {
        return ThresholdUtils.threshold(this.rowRanking(i), this.info.get("Threshold"));
    }

    public double[][] allPredictions() {
        double[][] Y = new double[this.predictions.size()][];
        for (int i = 0; i < this.predictions.size(); ++i) {
            Y[i] = this.rowRanking(i);
        }
        return Y;
    }

    public int[][] allPredictions(double t) {
        int[][] Y = new int[this.predictions.size()][];
        for (int i = 0; i < this.predictions.size(); ++i) {
            Y[i] = this.rowPrediction(i, t);
        }
        return Y;
    }

    public int[][] allActuals() {
        int[][] Y = new int[this.actuals.size()][];
        for (int i = 0; i < this.actuals.size(); ++i) {
            Y[i] = this.rowActual(i);
        }
        return Y;
    }

    public void addValue(String metric, double v) {
        Double freq = this.vals.get(metric);
        this.vals.put(metric, freq == null ? v : freq + v);
    }

    public void setValue(String metric, double v) {
        this.vals.put(metric, v);
    }

    public double getValue(String metric) {
        return this.vals.get(metric);
    }

    public void setInfo(String cat, String val) {
        this.info.put(cat, val);
    }

    public String getInfo(String cat) {
        return this.info.get(cat);
    }

    public static HashMap<String, Double> getStats(Result r, String vop) {
        if (r.getInfo("Type").equalsIgnoreCase("MT")) {
            return MLEvalUtils.getMTStats(r.allPredictions(), r.allActuals(), vop);
        }
        return MLEvalUtils.getMLStats(r.allPredictions(), r.allActuals(), r.getInfo("Threshold"), vop);
    }

    public static String getResultAsString(Result s) {
        return Result.getResultAsString(s, 3);
    }

    public static void writeResultToFile(Result result, String fname) throws Exception {
        PrintWriter outer = new PrintWriter(new BufferedWriter(new FileWriter(fname)));
        outer.write(result.toString());
        outer.close();
    }

    public static String getResultAsString(Result s, int adp) {
        StringBuilder sb = new StringBuilder();
        double N = s.predictions.size();
        sb.append("|==== PREDICTIONS (N=" + N + ") =====>\n");
        int i = 0;
        while ((double)i < N) {
            sb.append("|");
            sb.append(Utils.doubleToString((double)(i + 1), (int)5, (int)0));
            sb.append(" ");
            if (adp == 0 && !s.getInfo("Type").equalsIgnoreCase("MT")) {
                LabelSet y = new LabelSet(MLUtils.toIndicesSet(s.actuals.get(i)));
                sb.append(y).append(" ");
                LabelSet ypred = new LabelSet(MLUtils.toIndicesSet(s.rowPrediction(i)));
                sb.append(ypred).append("\n");
            } else {
                sb.append(A.toString(s.actuals.get(i)));
                sb.append(" ");
                sb.append(A.toString(s.predictions.get(i), adp));
                sb.append("\n");
            }
            ++i;
        }
        sb.append("|==============================<\n");
        return sb.toString();
    }
}

