/*
 * Decompiled with CFR 0.152.
 */
package meka.experiment;

import java.util.Random;
import meka.core.MLUtils;
import meka.experiment.MekaClassifierSplitEvaluator;
import meka.experiment.MekaResultProducer;
import meka.experiment.MekaSplitEvaluator;
import weka.core.Instances;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.experiment.CrossValidationSplitResultProducer;
import weka.experiment.OutputZipper;
import weka.experiment.ResultProducer;
import weka.experiment.SplitEvaluator;

public class MekaCrossValidationSplitResultProducer
extends CrossValidationSplitResultProducer
implements MekaResultProducer {
    static final long serialVersionUID = 1403798164046795073L;
    protected int m_TotalNumClasses = 0;

    public MekaCrossValidationSplitResultProducer() {
        this.m_SplitEvaluator = new MekaClassifierSplitEvaluator();
    }

    @Override
    public void setTotalNumClasses(int value) {
        this.m_TotalNumClasses = value;
        if (this.m_SplitEvaluator instanceof MekaSplitEvaluator) {
            ((MekaSplitEvaluator)this.m_SplitEvaluator).setTotalNumClasses(value);
        }
    }

    @Override
    public int getTotalNumClasses() {
        return this.m_TotalNumClasses;
    }

    public void setSplitEvaluator(SplitEvaluator newSplitEvaluator) {
        if (!(newSplitEvaluator instanceof MekaSplitEvaluator)) {
            throw new IllegalArgumentException("Split evaluator must implement " + MekaSplitEvaluator.class.getName() + ", provided: " + newSplitEvaluator.getClass().getName());
        }
        super.setSplitEvaluator(newSplitEvaluator);
    }

    public void doRun(int run) throws Exception {
        if (this.getRawOutput() && this.m_ZipDest == null) {
            this.m_ZipDest = new OutputZipper(this.m_OutputFile);
        }
        if (this.m_Instances == null) {
            throw new Exception("No Instances set");
        }
        int fold = (run - 1) % this.m_NumFolds;
        run = (run - 1) / this.m_NumFolds + 1;
        Instances runInstances = new Instances(this.m_Instances);
        Random random = new Random(run);
        runInstances.randomize(random);
        Object[] seKey = this.m_SplitEvaluator.getKey();
        Object[] key = new Object[seKey.length + 3];
        key[0] = Utils.backQuoteChars((String)this.m_Instances.relationName());
        key[1] = "" + run;
        key[2] = "" + (fold + 1);
        System.arraycopy(seKey, 0, key, 3, seKey.length);
        if (this.m_ResultListener.isResultRequired((ResultProducer)this, key)) {
            for (int tempFold = 0; tempFold < fold; ++tempFold) {
                runInstances.trainCV(this.m_NumFolds, tempFold, random);
            }
            Instances train = runInstances.trainCV(this.m_NumFolds, fold, random);
            Instances test = runInstances.testCV(this.m_NumFolds, fold);
            MLUtils.prepareData(train);
            MLUtils.prepareData(test);
            Object[] seResults = this.m_SplitEvaluator.getResult(train, test);
            Object[] results = new Object[seResults.length + 1];
            results[0] = MekaCrossValidationSplitResultProducer.getTimestamp();
            System.arraycopy(seResults, 0, results, 1, seResults.length);
            if (this.m_debugOutput) {
                String resultName = ("" + run + "." + (fold + 1) + "." + Utils.backQuoteChars((String)runInstances.relationName()) + "." + this.m_SplitEvaluator.toString()).replace(' ', '_');
                resultName = Utils.removeSubstring((String)resultName, (String)"weka.classifiers.");
                resultName = Utils.removeSubstring((String)resultName, (String)"meka.classifiers.");
                resultName = Utils.removeSubstring((String)resultName, (String)"weka.filters.");
                resultName = Utils.removeSubstring((String)resultName, (String)"meka.filters.");
                resultName = Utils.removeSubstring((String)resultName, (String)"weka.attributeSelection.");
                this.m_ZipDest.zipit(this.m_SplitEvaluator.getRawResultOutput(), resultName);
            }
            this.m_ResultListener.acceptResult((ResultProducer)this, key, results);
        }
    }

    public String getRevision() {
        return RevisionUtils.extract((String)"$Revision: 10203 $");
    }
}

