/*
 * Decompiled with CFR 0.152.
 */
package meka.experiment;

import java.util.Random;
import meka.core.MLUtils;
import meka.experiment.MekaResultProducer;
import meka.experiment.MekaSplitEvaluator;
import weka.core.Instances;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.experiment.OutputZipper;
import weka.experiment.RandomSplitResultProducer;
import weka.experiment.ResultProducer;

public class MekaRandomSplitResultProducer
extends RandomSplitResultProducer
implements MekaResultProducer {
    static final long serialVersionUID = 1403798165056795073L;
    protected int m_TotalNumClasses = 0;

    @Override
    public void setTotalNumClasses(int value) {
        this.m_TotalNumClasses = value;
        if (this.m_SplitEvaluator instanceof MekaSplitEvaluator) {
            ((MekaSplitEvaluator)this.m_SplitEvaluator).setTotalNumClasses(value);
        }
    }

    @Override
    public int getTotalNumClasses() {
        return this.m_TotalNumClasses;
    }

    public void doRun(int run) throws Exception {
        if (this.getRawOutput() && this.m_ZipDest == null) {
            this.m_ZipDest = new OutputZipper(this.m_OutputFile);
        }
        if (this.m_Instances == null) {
            throw new Exception("No Instances set");
        }
        Object[] seKey = this.m_SplitEvaluator.getKey();
        Object[] key = new Object[seKey.length + 2];
        key[0] = Utils.backQuoteChars((String)this.m_Instances.relationName());
        key[1] = "" + run;
        System.arraycopy(seKey, 0, key, 2, seKey.length);
        if (this.m_ResultListener.isResultRequired((ResultProducer)this, key)) {
            Instances runInstances = new Instances(this.m_Instances);
            if (this.m_randomize) {
                Random rand = new Random(run);
                runInstances.randomize(rand);
            }
            int trainSize = Utils.round((double)((double)runInstances.numInstances() * this.m_TrainPercent / 100.0));
            int testSize = runInstances.numInstances() - trainSize;
            Instances train = new Instances(runInstances, 0, trainSize);
            Instances test = new Instances(runInstances, trainSize, testSize);
            MLUtils.prepareData(train);
            test.setClassIndex(this.m_Instances.classIndex());
            MLUtils.prepareData(test);
            test.setClassIndex(this.m_Instances.classIndex());
            Object[] seResults = this.m_SplitEvaluator.getResult(train, test);
            Object[] results = new Object[seResults.length + 1];
            results[0] = MekaRandomSplitResultProducer.getTimestamp();
            System.arraycopy(seResults, 0, results, 1, seResults.length);
            if (this.m_debugOutput) {
                String resultName = ("" + run + "." + Utils.backQuoteChars((String)runInstances.relationName()) + "." + this.m_SplitEvaluator.toString()).replace(' ', '_');
                resultName = Utils.removeSubstring((String)resultName, (String)"weka.classifiers.");
                resultName = Utils.removeSubstring((String)resultName, (String)"meka.classifiers.");
                resultName = Utils.removeSubstring((String)resultName, (String)"weka.filters.");
                resultName = Utils.removeSubstring((String)resultName, (String)"meka.filters.");
                resultName = Utils.removeSubstring((String)resultName, (String)"weka.attributeSelection.");
                this.m_ZipDest.zipit(this.m_SplitEvaluator.getRawResultOutput(), resultName);
            }
            this.m_ResultListener.acceptResult((ResultProducer)this, key, results);
        }
    }

    public String getRevision() {
        return RevisionUtils.extract((String)"$Revision: 10203 $");
    }
}

