/*
 * Decompiled with CFR 0.152.
 */
package meka.filters.unsupervised.attribute;

import java.util.Enumeration;
import java.util.Vector;
import weka.core.Capabilities;
import weka.core.CapabilitiesHandler;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.Range;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.core.WekaException;
import weka.filters.Filter;
import weka.filters.SimpleStreamFilter;
import weka.filters.unsupervised.attribute.Reorder;

public class MekaClassAttributes
extends SimpleStreamFilter {
    private static final long serialVersionUID = 6733841542030233313L;
    protected Range m_AttributeIndices = new Range("last");
    protected Reorder m_Reorder = new Reorder();

    public String globalInfo() {
        return "Reorders attributes for MEKA. Attribute range defines the attributes to use as class attributes.";
    }

    public Enumeration listOptions() {
        Vector<Option> newVector = new Vector<Option>();
        newVector.addElement(new Option("\tSpecify list of columns to use as MEKA class attributes. 'first' and 'last' are valid\n\tindexes. (default: last)", "R", 1, "-R <index1,index2-index4,...>"));
        return newVector.elements();
    }

    public void setOptions(String[] options) throws Exception {
        String orderList = Utils.getOption((char)'R', (String[])options);
        if (orderList.length() != 0) {
            this.setAttributeIndices(orderList);
        } else {
            this.setAttributeIndices("last");
        }
        if (this.getInputFormat() != null) {
            this.setInputFormat(this.getInputFormat());
        }
    }

    public String[] getOptions() {
        String[] options = new String[2];
        int current = 0;
        if (!this.getAttributeIndices().equals("")) {
            options[current++] = "-R";
            options[current++] = this.getAttributeIndices();
        }
        while (current < options.length) {
            options[current++] = "";
        }
        return options;
    }

    public void setAttributeIndices(String value) throws Exception {
        if (value.replaceAll("[afilrst0-9\\-,]*", "").length() != 0) {
            throw new IllegalArgumentException("Not a valid range string!");
        }
        this.m_AttributeIndices.setRanges(value);
    }

    public String getAttributeIndices() {
        return this.m_AttributeIndices.getRanges();
    }

    public String attributeIndicesTipText() {
        return "Specify range of attributes to use as MEKA class attributes. This is a comma separated list of attribute indices, with \"first\" and \"last\" valid values. Specify an inclusive range with \"-\". E.g: \"first-3,5,6-10,last\".";
    }

    public Capabilities getCapabilities() {
        Capabilities result = this.m_Reorder.getCapabilities();
        result.setOwner((CapabilitiesHandler)this);
        return result;
    }

    protected Instances determineOutputFormat(Instances inputFormat) throws Exception {
        int i;
        this.m_AttributeIndices.setUpper(inputFormat.numAttributes() - 1);
        StringBuilder order = new StringBuilder();
        int[] indices = this.m_AttributeIndices.getSelection();
        if (indices.length == 0) {
            throw new WekaException("No attributes defined as class attributes!");
        }
        for (i = 0; i < indices.length; ++i) {
            if (i > 0) {
                order.append(",");
            }
            order.append("" + (indices[i] + 1));
        }
        for (i = 0; i < inputFormat.numAttributes(); ++i) {
            if (this.m_AttributeIndices.isInRange(i)) continue;
            order.append(",");
            order.append("" + (i + 1));
        }
        this.m_Reorder.setAttributeIndices(order.toString());
        this.m_Reorder.setInputFormat(inputFormat);
        Instances output = this.m_Reorder.getOutputFormat();
        output.setClassIndex(indices.length);
        output.setRelationName("-C " + indices.length);
        return output;
    }

    protected Instance process(Instance instance) throws Exception {
        this.m_Reorder.input(instance);
        this.m_Reorder.batchFinished();
        return this.m_Reorder.output();
    }

    public String getRevision() {
        return RevisionUtils.extract((String)"$Revision: 66 $");
    }

    public static void main(String[] args) {
        MekaClassAttributes.runFilter((Filter)new MekaClassAttributes(), (String[])args);
    }
}

