/*
 * Decompiled with CFR 0.152.
 */
package meka.gui.explorer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Random;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import meka.classifiers.multilabel.BR;
import meka.classifiers.multilabel.Evaluation;
import meka.classifiers.multilabel.MultilabelClassifier;
import meka.classifiers.multilabel.incremental.IncrementalEvaluation;
import meka.core.MLEvalUtils;
import meka.core.MLUtils;
import meka.core.Result;
import meka.gui.core.GUIHelper;
import meka.gui.core.ResultHistoryList;
import meka.gui.explorer.AbstractThreadedExplorerTab;
import meka.gui.explorer.ClassifyTabOptions;
import meka.gui.explorer.Explorer;
import meka.gui.goe.GenericObjectEditor;
import weka.core.Instances;

public class ClassifyTab
extends AbstractThreadedExplorerTab {
    private static final long serialVersionUID = 2158821659456232147L;
    public static final String TYPE_CROSSVALIDATION = "Cross-validation";
    public static final String TYPE_TRAINTESTSPLIT = "Train/test split";
    public static final String TYPE_INCREMENTAL = "Incremental eval.";
    protected GenericObjectEditor m_GenericObjectEditor;
    protected JTextArea m_TextAreaResults;
    protected ResultHistoryList m_ResultHistoryList;
    protected JButton m_ButtonStart;
    protected JButton m_ButtonStop;
    protected JComboBox m_ComboBoxExperiment;
    protected JButton m_ButtonOptions;
    protected int m_Seed;
    protected double m_SplitPercentage;
    protected String m_TOP;
    protected String m_VOP;
    protected boolean m_Randomize;
    protected int m_Folds;
    protected Instances m_TestInstances;

    public ClassifyTab(Explorer owner) {
        super(owner);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_GenericObjectEditor = new GenericObjectEditor(true);
        this.m_GenericObjectEditor.setClassType(MultilabelClassifier.class);
        this.m_GenericObjectEditor.setValue((Object)new BR());
        this.m_Seed = 1;
        this.m_SplitPercentage = 66.0;
        this.m_Folds = 10;
        this.m_Randomize = true;
        this.m_TOP = "PCut1";
        this.m_VOP = "3";
        this.m_TestInstances = null;
    }

    @Override
    protected void initGUI() {
        super.initGUI();
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createTitledBorder("Classifier"));
        panel.add((Component)this.m_GenericObjectEditor.getCustomPanel(), "Center");
        this.add((Component)panel, "North");
        JPanel panelSplit = new JPanel(new BorderLayout());
        this.add((Component)panelSplit, "Center");
        JPanel panelLeft = new JPanel(new BorderLayout());
        panelSplit.add((Component)panelLeft, "West");
        JPanel panelEval = new JPanel(new BorderLayout());
        panelEval.setBorder(BorderFactory.createTitledBorder("Evaluation"));
        panelLeft.add((Component)panelEval, "North");
        panel = new JPanel(new FlowLayout(0));
        panelEval.add((Component)panel, "Center");
        this.m_ComboBoxExperiment = new JComboBox<String>(new String[]{TYPE_TRAINTESTSPLIT, TYPE_CROSSVALIDATION, TYPE_INCREMENTAL});
        this.m_ComboBoxExperiment.setSelectedIndex(0);
        panel.add(this.m_ComboBoxExperiment);
        this.m_ButtonOptions = new JButton("...");
        this.m_ButtonOptions.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ClassifyTab.this.showOptions();
            }
        });
        panel.add(this.m_ButtonOptions);
        panel = new JPanel(new GridLayout(1, 2));
        panelEval.add((Component)panel, "South");
        this.m_ButtonStart = new JButton("Start");
        this.m_ButtonStart.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ClassifyTab.this.startClassification();
            }
        });
        panel.add((Component)this.m_ButtonStart, "South");
        this.m_ButtonStop = new JButton("Stop");
        this.m_ButtonStop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ClassifyTab.this.stopClassification();
            }
        });
        panel.add(this.m_ButtonStop);
        this.m_ResultHistoryList = new ResultHistoryList();
        this.m_ResultHistoryList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ClassifyTab.this.displayResults();
            }
        });
        panel = new JPanel(new BorderLayout());
        panel.add((Component)new JScrollPane(this.m_ResultHistoryList), "Center");
        panel.setBorder(BorderFactory.createTitledBorder("History"));
        panelLeft.add(panel);
        this.m_TextAreaResults = new JTextArea();
        this.m_TextAreaResults.setFont(GUIHelper.getMonospacedFont());
        panel = new JPanel(new BorderLayout());
        panel.add((Component)new JScrollPane(this.m_TextAreaResults), "Center");
        panel.setBorder(BorderFactory.createTitledBorder("Result"));
        panelSplit.add((Component)panel, "Center");
    }

    protected void startClassification() {
        if (this.m_ComboBoxExperiment.getSelectedIndex() == -1) {
            return;
        }
        final Instances data = new Instances(this.getData());
        if (this.m_Randomize) {
            data.randomize(new Random(this.m_Seed));
        }
        String type = this.m_ComboBoxExperiment.getSelectedItem().toString();
        Runnable run = null;
        if (type.equals(TYPE_CROSSVALIDATION)) {
            run = new Runnable(){

                @Override
                public void run() {
                    ClassifyTab.this.startBusy("Cross-validating...");
                    try {
                        MultilabelClassifier classifier = (MultilabelClassifier)((Object)ClassifyTab.this.m_GenericObjectEditor.getValue());
                        Result[] results = Evaluation.cvModel(classifier, data, ClassifyTab.this.m_Folds, ClassifyTab.this.m_TOP, ClassifyTab.this.m_VOP);
                        ClassifyTab.this.addResultToHistory(MLEvalUtils.averageResults(results), ((Object)((Object)classifier)).getClass().getName().replace("meka.classifiers.", ""));
                        ClassifyTab.this.finishBusy("");
                    }
                    catch (Exception e) {
                        System.err.println("Evaluation failed:");
                        e.printStackTrace();
                        ClassifyTab.this.finishBusy("Evaluation failed: " + e);
                        JOptionPane.showMessageDialog(ClassifyTab.this, "Evaluation failed (CV):\n" + e, "Error", 0);
                    }
                }
            };
        } else if (type.equals(TYPE_TRAINTESTSPLIT)) {
            run = new Runnable(){

                @Override
                public void run() {
                    ClassifyTab.this.startBusy("Train/test split...");
                    try {
                        Instances test;
                        Instances train;
                        if (ClassifyTab.this.m_TestInstances == null) {
                            int trainSize = (int)((double)data.numInstances() * ClassifyTab.this.m_SplitPercentage / 100.0);
                            train = new Instances(data, 0, trainSize);
                            test = new Instances(data, trainSize, data.numInstances() - trainSize);
                        } else {
                            train = new Instances(data);
                            MLUtils.prepareData(ClassifyTab.this.m_TestInstances);
                            test = new Instances(ClassifyTab.this.m_TestInstances);
                            test.setClassIndex(data.classIndex());
                        }
                        MultilabelClassifier classifier = (MultilabelClassifier)((Object)ClassifyTab.this.m_GenericObjectEditor.getValue());
                        Result result = Evaluation.evaluateModel(classifier, train, test, ClassifyTab.this.m_TOP, ClassifyTab.this.m_VOP);
                        ClassifyTab.this.addResultToHistory(result, ((Object)((Object)classifier)).getClass().getName().replace("meka.classifiers.", ""));
                        ClassifyTab.this.finishBusy("");
                    }
                    catch (Exception e) {
                        System.err.println("Evaluation failed (train/test split):");
                        e.printStackTrace();
                        ClassifyTab.this.finishBusy("Evaluation failed: " + e);
                        JOptionPane.showMessageDialog(ClassifyTab.this, "Evaluation failed:\n" + e, "Error", 0);
                    }
                }
            };
        } else if (type.equals(TYPE_INCREMENTAL)) {
            run = new Runnable(){

                @Override
                public void run() {
                    ClassifyTab.this.startBusy("Incremental...");
                    try {
                        Result[] results;
                        MultilabelClassifier classifier = (MultilabelClassifier)((Object)ClassifyTab.this.m_GenericObjectEditor.getValue());
                        for (Result result : results = IncrementalEvaluation.evaluateModel(classifier, data, 20, 1.0, ClassifyTab.this.m_TOP, ClassifyTab.this.m_VOP)) {
                            ClassifyTab.this.addResultToHistory(result, ((Object)((Object)classifier)).getClass().getName().replace("meka.classifiers.", ""));
                        }
                        ClassifyTab.this.finishBusy("");
                    }
                    catch (Exception e) {
                        System.err.println("Evaluation failed (incremental splits):");
                        e.printStackTrace();
                        ClassifyTab.this.finishBusy("Evaluation failed: " + e);
                        JOptionPane.showMessageDialog(ClassifyTab.this, "Evaluation failed:\n" + e, "Error", 0);
                    }
                }
            };
        }
        this.start(run);
    }

    protected void stopClassification() {
        if (this.isRunning()) {
            this.stop();
            this.startBusy("Evaluation interrupted!");
        }
    }

    protected void showOptions() {
        final JDialog dialog = GUIHelper.getParentDialog(this) != null ? new JDialog((Window)GUIHelper.getParentDialog(this), Dialog.ModalityType.DOCUMENT_MODAL) : new JDialog(GUIHelper.getParentFrame(this), true);
        dialog.setTitle("Options");
        dialog.getContentPane().setLayout(new BorderLayout());
        final ClassifyTabOptions panel = new ClassifyTabOptions();
        panel.setSeed(this.m_Seed);
        panel.setFolds(this.m_Folds);
        panel.setSplitPercentage(this.m_SplitPercentage);
        panel.setTOP(this.m_TOP);
        panel.setVOP(this.m_VOP);
        panel.setRandomize(this.m_Randomize);
        panel.setTestFile(null);
        dialog.getContentPane().add((Component)panel, "Center");
        JPanel panelButtons = new JPanel(new FlowLayout(2));
        dialog.getContentPane().add((Component)panelButtons, "South");
        JButton buttonOK = new JButton("OK");
        buttonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ClassifyTab.this.m_Seed = panel.getSeed();
                ClassifyTab.this.m_SplitPercentage = panel.getSplitPercentage();
                ClassifyTab.this.m_Folds = panel.getFolds();
                ClassifyTab.this.m_TOP = panel.getTOP();
                ClassifyTab.this.m_VOP = panel.getVOP();
                ClassifyTab.this.m_Randomize = panel.getRandomize();
                ClassifyTab.this.m_TestInstances = panel.getTestFile();
                dialog.setVisible(false);
                dialog.dispose();
            }
        });
        panelButtons.add(buttonOK);
        JButton buttonCancel = new JButton("Cancel");
        buttonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                dialog.setVisible(false);
                dialog.dispose();
            }
        });
        panelButtons.add(buttonCancel);
        dialog.pack();
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
    }

    protected void addResultToHistory(final Result result, final String suffix) {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                ClassifyTab.this.m_ResultHistoryList.addResult(result, suffix);
            }
        };
        SwingUtilities.invokeLater(run);
    }

    protected void displayResults() {
        if (this.m_ResultHistoryList.getSelectedIndex() == -1) {
            this.m_TextAreaResults.setText("");
            return;
        }
        Result result = this.m_ResultHistoryList.getResultAt(this.m_ResultHistoryList.getSelectedIndex());
        if (result == null) {
            return;
        }
        this.m_TextAreaResults.setText(result.toString());
    }

    @Override
    public String getTitle() {
        return "Classify";
    }

    @Override
    protected void update() {
        this.m_ButtonStart.setEnabled(this.hasData());
        this.m_ButtonStop.setEnabled(this.isRunning());
    }

    @Override
    protected void executionStarted() {
        this.m_ButtonStart.setEnabled(false);
        this.m_ButtonStop.setEnabled(true);
    }

    @Override
    protected void executionFinished(Throwable t) {
        this.m_ButtonStart.setEnabled(true);
        this.m_ButtonStop.setEnabled(false);
        if (t != null) {
            System.err.println("Execution failed:");
            t.printStackTrace();
            JOptionPane.showMessageDialog(this, "Execution failed:\n" + t, "Error", 0);
        }
    }
}

