/*
 * Decompiled with CFR 0.152.
 */
package meka.gui.goe;

import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyEditor;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import meka.classifiers.multilabel.BR;
import meka.classifiers.multilabel.MultilabelClassifier;
import meka.core.PropsUtils;
import meka.gui.goe.GenericPropertiesCreator;
import weka.core.OptionHandler;
import weka.core.Utils;
import weka.core.logging.Logger;
import weka.gui.HierarchyPropertyParser;
import weka.gui.PropertyDialog;
import weka.gui.beans.PluginManager;

public class GenericObjectEditor
extends weka.gui.GenericObjectEditor {
    protected static Properties MEKA_EDITOR_PROPERTIES;
    public static final String MEKA_GUIEDITORS_PROPERTY_FILE = "meka/gui/goe/MekaEditors.props";
    public static boolean DEBUG;
    protected static boolean m_MekaEditorsRegistered;

    public static void determineAllClasses() {
        weka.gui.GenericObjectEditor.determineClasses();
        try {
            GenericPropertiesCreator creator = new GenericPropertiesCreator();
            try {
                creator.execute(false);
                MEKA_EDITOR_PROPERTIES = creator.getOutputProperties();
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, "Could not determine the properties for the generic object\neditor. This exception was produced:\n" + e.toString(), "MEKA GenericObjectEditor", 0);
            }
            if (MEKA_EDITOR_PROPERTIES == null) {
                JOptionPane.showMessageDialog(null, "Could not initialize the MEKA GenericPropertiesCreator. ", "MEKA GenericObjectEditor", 0);
            } else {
                PluginManager.addFromProperties((Properties)MEKA_EDITOR_PROPERTIES);
                Enumeration<?> keys = MEKA_EDITOR_PROPERTIES.propertyNames();
                while (keys.hasMoreElements()) {
                    String key = (String)keys.nextElement();
                    if (EDITOR_PROPERTIES.containsKey(key)) {
                        EDITOR_PROPERTIES.setProperty(key, EDITOR_PROPERTIES.getProperty(key) + "," + MEKA_EDITOR_PROPERTIES.getProperty(key));
                        continue;
                    }
                    EDITOR_PROPERTIES.setProperty(key, MEKA_EDITOR_PROPERTIES.getProperty(key));
                }
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Could not initialize the MEKA GenericPropertiesCreator. This exception was produced:\n" + e.toString(), "MEKA GenericObjectEditor", 0);
        }
        if (DEBUG) {
            System.out.println("start<GenericObjectEditor.determineAllClasses()>\n" + PropsUtils.toString(EDITOR_PROPERTIES, null) + "end<GenericObjectEditor.determineAllClasses()>\n");
        }
    }

    public static void registerAllEditors() {
        Properties props;
        GenericObjectEditor.registerEditors();
        if (m_MekaEditorsRegistered) {
            return;
        }
        System.err.println("---Registering MEKA Editors---");
        m_MekaEditorsRegistered = true;
        try {
            props = PropsUtils.read(MEKA_GUIEDITORS_PROPERTY_FILE);
            if (DEBUG) {
                System.out.println("start<GenericObjectEditor.registerAllEditors()>\n" + PropsUtils.toString(props, null) + "end<GenericObjectEditor.registerAllEditors()>\n");
            }
        }
        catch (Exception e) {
            props = new Properties();
            e.printStackTrace();
        }
        Enumeration<?> enm = props.propertyNames();
        while (enm.hasMoreElements()) {
            String name = enm.nextElement().toString();
            String value = props.getProperty(name, "");
            GenericObjectEditor.registerEditor((String)name, (String)value);
        }
    }

    public GenericObjectEditor() {
    }

    public GenericObjectEditor(boolean canChangeClassInDialog) {
        super(canChangeClassInDialog);
    }

    protected Hashtable<String, HierarchyPropertyParser> getClassesFromProperties() {
        String className = this.m_ClassType.getName();
        if (className.startsWith("meka.")) {
            Hashtable<String, HierarchyPropertyParser> hpps = new Hashtable<String, HierarchyPropertyParser>();
            Hashtable typeOptions = GenericObjectEditor.sortClassesByRoot((String)EDITOR_PROPERTIES.getProperty(className));
            try {
                Enumeration enm = typeOptions.keys();
                while (enm.hasMoreElements()) {
                    String root = (String)enm.nextElement();
                    String typeOption = (String)typeOptions.get(root);
                    HierarchyPropertyParser hpp = new HierarchyPropertyParser();
                    hpp.build(typeOption, ", ");
                    hpps.put(root, hpp);
                }
            }
            catch (Exception ex) {
                Logger.log((Logger.Level)Logger.Level.WARNING, (String)("Invalid property: " + typeOptions));
            }
            if (DEBUG) {
                System.out.println("Meka classes: " + hpps);
            }
            return hpps;
        }
        return super.getClassesFromProperties();
    }

    public JPopupMenu getChooseClassPopupMenu() {
        if (DEBUG) {
            System.out.println("Objectnames: " + this.m_ObjectNames);
        }
        return super.getChooseClassPopupMenu();
    }

    public static void main(String[] args) {
        try {
            GenericObjectEditor.registerAllEditors();
            GenericObjectEditor ce = new GenericObjectEditor(true);
            ce.setClassType(MultilabelClassifier.class);
            BR initial = new BR();
            if (args.length > 0) {
                ce.setClassType(Class.forName(args[0]));
                if (args.length > 1) {
                    initial = Class.forName(args[1]).newInstance();
                    ce.setValue((Object)initial);
                } else {
                    ce.setDefaultValue();
                }
            } else {
                ce.setValue((Object)initial);
            }
            PropertyDialog pd = new PropertyDialog((Frame)null, (PropertyEditor)((Object)ce), 100, 100);
            pd.addWindowListener((WindowListener)new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    PropertyEditor pe = ((PropertyDialog)e.getSource()).getEditor();
                    Object c = pe.getValue();
                    String options = "";
                    if (c instanceof OptionHandler) {
                        options = Utils.joinOptions((String[])((OptionHandler)c).getOptions());
                    }
                    System.out.println(c.getClass().getName() + " " + options);
                    System.exit(0);
                }
            });
            pd.setVisible(true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.err.println(ex.getMessage());
        }
    }

    static {
        DEBUG = "true".equals(System.getenv("MEKA_DEBUG"));
        if (DEBUG) {
            PropsUtils.DEBUG = true;
        }
        GenericObjectEditor.determineAllClasses();
    }
}

